/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.snowflake.client.jdbc.SnowflakePreparedStatement;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryClient;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.ServerConnection;
import net.snowflake.spark.snowflake.ServerConnection$;
import net.snowflake.spark.snowflake.Utils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}h!\u0002\r\u001a\u0001e\u0001\u0003\"B\u0014\u0001\t\u0003I\u0003b\u0002\u0017\u0001\u0005\u0004%I!\f\u0005\u0007m\u0001\u0001\u000b\u0011\u0002\u0018\t\u000f]\u0002!\u0019!C\u0005q!1q\b\u0001Q\u0001\neBQ\u0001\u0011\u0001\u0005\u0002\u0005CQ\u0001\u001d\u0001\u0005\u0002EDQ! \u0001\u0005\u0002yDq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\u000e\u0001!\t!a\u0004\t\u0011\u0005m\u0001\u0001\"\u0001\u001a\u0003;Aq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u0002*\u0001!\t!a\u000e\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003bBA\u001f\u0001\u0011\u0005\u0011q\n\u0005\b\u0003+\u0002A\u0011AA,\u0011\u001d\t)\u0007\u0001C\u0001\u0003OBq!!\u0016\u0001\t\u0003\ti\u0007C\u0004\u0002f\u0001!\t!a\u001d\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002z!9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0006bBA`\u0001\u0011\u0005\u0011\u0011\u0019\u0002\f\u0015\u0012\u00135i\u0016:baB,'O\u0003\u0002\u001b7\u0005I1O\\8xM2\f7.\u001a\u0006\u00039u\tQa\u001d9be.T!A\u0007\u0010\u000b\u0003}\t1A\\3u'\t\u0001\u0011\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t!\u0006\u0005\u0002,\u00015\t\u0011$A\u0002m_\u001e,\u0012A\f\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\nQa\u001d7gi)T\u0011aM\u0001\u0004_J<\u0017BA\u001b1\u0005\u0019aunZ4fe\u0006!An\\4!\u0003\t)7-F\u0001:!\tQT(D\u0001<\u0015\ta4%\u0001\u0006d_:\u001cWO\u001d:f]RL!AP\u001e\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA3dA\u0005a!/Z:pYZ,G+\u00192mKR!!)\u0014*`!\t\u00195*D\u0001E\u0015\t)e)A\u0003usB,7O\u0003\u0002H\u0011\u0006\u00191/\u001d7\u000b\u0005qI%B\u0001&3\u0003\u0019\t\u0007/Y2iK&\u0011A\n\u0012\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"\u0002(\u0007\u0001\u0004y\u0015\u0001B2p]:\u0004\"a\u000b)\n\u0005EK\"\u0001E*feZ,'oQ8o]\u0016\u001cG/[8o\u0011\u0015\u0019f\u00011\u0001U\u0003\u0015!\u0018M\u00197f!\t)FL\u0004\u0002W5B\u0011qkI\u0007\u00021*\u0011\u0011\fK\u0001\u0007yI|w\u000e\u001e \n\u0005m\u001b\u0013A\u0002)sK\u0012,g-\u0003\u0002^=\n11\u000b\u001e:j]\u001eT!aW\u0012\t\u000b\u00014\u0001\u0019A1\u0002\rA\f'/Y7t!\t\u0011WN\u0004\u0002dW:\u0011AM\u001b\b\u0003K&t!A\u001a5\u000f\u0005];\u0017\"A\u0010\n\u0005iq\u0012B\u0001\u000f\u001e\u0013\tQ2$\u0003\u0002m3\u0005Q\u0001+\u0019:b[\u0016$XM]:\n\u00059|'\u0001E'fe\u001e,G\rU1sC6,G/\u001a:t\u0015\ta\u0017$\u0001\u000bsKN|GN^3UC\ndWM\u0012:p[6+G/\u0019\u000b\u0005\u0005J\u001cH\u0010C\u0003O\u000f\u0001\u0007q\nC\u0003u\u000f\u0001\u0007Q/\u0001\u0003sg6$\u0007C\u0001<{\u001b\u00059(BA$y\u0015\u0005I\u0018\u0001\u00026bm\u0006L!a_<\u0003#I+7/\u001e7u'\u0016$X*\u001a;b\t\u0006$\u0018\rC\u0003a\u000f\u0001\u0007\u0011-\u0001\u0007hKR\u001cuN\u001c8fGR|'\u000f\u0006\u0002P\u007f\")\u0001\r\u0003a\u0001C\u0006a1o\u00195f[\u0006\u001cFO]5oOR)A+!\u0002\u0002\n!1\u0011qA\u0005A\u0002\t\u000baa]2iK6\f\u0007BBA\u0006\u0013\u0001\u0007\u0011-A\u0003qCJ\fW.\u0001\ttG\",W.Y\"p]Z,'o]5p]R\u0019A+!\u0005\t\u000f\u0005M!\u00021\u0001\u0002\u0016\u0005)a-[3mIB\u00191)a\u0006\n\u0007\u0005eAIA\u0006TiJ,8\r\u001e$jK2$\u0017a\u0003;bE2,W\t_5tiN$b!a\b\u0002&\u0005\u001d\u0002c\u0001\u0012\u0002\"%\u0019\u00111E\u0012\u0003\u000f\t{w\u000e\\3b]\")\u0001m\u0003a\u0001C\")1k\u0003a\u0001)\u0006aR\r_3dkR,\u0007K]3qCJ,G-\u00138uKJ\u0014X\u000f\u001d;jE2LH\u0003BA\u0010\u0003[Aq!a\f\r\u0001\u0004\t\t$A\u0005ti\u0006$X-\\3oiB\u0019a/a\r\n\u0007\u0005UrOA\tQe\u0016\u0004\u0018M]3e'R\fG/Z7f]R$b!a\b\u0002:\u0005m\u0002\"\u0002(\u000e\u0001\u0004y\u0005\"B$\u000e\u0001\u0004!\u0016!I3yK\u000e,H/\u001a)sKB\f'/\u001a3Rk\u0016\u0014\u00180\u00138uKJ\u0014X\u000f\u001d;jE2LH\u0003BA!\u0003\u000f\u00022A^A\"\u0013\r\t)e\u001e\u0002\n%\u0016\u001cX\u000f\u001c;TKRDq!a\f\u000f\u0001\u0004\t\t$\u0001\u0014fq\u0016\u001cW\u000f^3Qe\u0016\u0004\u0018M]3e#V,'/_!ts:\u001c\u0017J\u001c;feJ,\b\u000f^5cYf$B!!\u0011\u0002N!9\u0011qF\bA\u0002\u0005EBCBA!\u0003#\n\u0019\u0006C\u0003O!\u0001\u0007q\nC\u0003H!\u0001\u0007A+A\rfq\u0016\u001cW\u000f^3Rk\u0016\u0014\u00180\u00138uKJ\u0014X\u000f\u001d;jE2LHCBA!\u00033\n\t\u0007C\u0004\u00020E\u0001\r!a\u0017\u0011\u0007Y\fi&C\u0002\u0002`]\u0014\u0011b\u0015;bi\u0016lWM\u001c;\t\r\u0005\r\u0014\u00031\u0001U\u0003\r\u0019HO]\u0001\u0015Kb,7-\u001e;f\u0013:$XM\u001d:vaRL'\r\\=\u0015\r\u0005}\u0011\u0011NA6\u0011\u001d\tyC\u0005a\u0001\u00037Ba!a\u0019\u0013\u0001\u0004!FCBA!\u0003_\n\t\bC\u0003O'\u0001\u0007q\nC\u0003H'\u0001\u0007A\u000b\u0006\u0004\u0002 \u0005U\u0014q\u000f\u0005\u0006\u001dR\u0001\ra\u0014\u0005\u0006\u000fR\u0001\r\u0001V\u000b\u0005\u0003w\n\t\t\u0006\u0004\u0002~\u0005M\u0015Q\u0013\t\u0005\u0003\u007f\n\t\t\u0004\u0001\u0005\u000f\u0005\rUC1\u0001\u0002\u0006\n\tA+\u0005\u0003\u0002\b\u00065\u0005c\u0001\u0012\u0002\n&\u0019\u00111R\u0012\u0003\u000f9{G\u000f[5oOB\u0019!%a$\n\u0007\u0005E5EA\u0002B]fDq!a\f\u0016\u0001\u0004\tY\u0006C\u0004\u0002\u0018V\u0001\r!!'\u0002\u0005=\u0004\bc\u0002\u0012\u0002\u001c\u0006m\u0013QP\u0005\u0004\u0003;\u001b#!\u0003$v]\u000e$\u0018n\u001c82\u0003=9W\r^\"bi\u0006d\u0017p\u001d;UsB,GCCAR\u0003S\u000b\u0019,a.\u0002<B\u00191)!*\n\u0007\u0005\u001dFI\u0001\u0005ECR\fG+\u001f9f\u0011\u001d\tYK\u0006a\u0001\u0003[\u000bqa]9m)f\u0004X\rE\u0002#\u0003_K1!!-$\u0005\rIe\u000e\u001e\u0005\b\u0003k3\u0002\u0019AAW\u0003%\u0001(/Z2jg&|g\u000eC\u0004\u0002:Z\u0001\r!!,\u0002\u000bM\u001c\u0017\r\\3\t\u000f\u0005uf\u00031\u0001\u0002 \u000511/[4oK\u0012\fAbZ3u)\u0016dW-\\3uef$B!a1\u0002XB!\u0011QYAj\u001b\t\t9M\u0003\u0003\u0002J\u0006-\u0017!\u0003;fY\u0016lW\r\u001e:z\u0015\u0011\ti-a4\u0002\t)$'m\u0019\u0006\u0004\u0003#l\u0012AB2mS\u0016tG/\u0003\u0003\u0002V\u0006\u001d'!\u0003+fY\u0016lW\r\u001e:z\u0011\u0015qu\u00031\u0001PQ\u001d9\u00121\\Aq\u0003k\u00042AIAo\u0013\r\tyn\t\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017\u0007C\u0012U\u0003G\fY/!:\n\t\u0005\u0015\u0018q]\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u000b\u0007\u0005%8%\u0001\u0006eKB\u0014XmY1uK\u0012\f\u0014bIAw\u0003_\f\t0!;\u000f\u0007\t\ny/C\u0002\u0002j\u000e\nTA\t\u0012$\u0003g\u0014Qa]2bY\u0006\f\u0004b\t+\u0002x\u0006m\u0018\u0011`\u0005\u0005\u0003s\f9/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0019\nG\u00055\u0018q^A\u007f\u0003S\fTA\t\u0012$\u0003g\u0004")
public class JDBCWrapper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ExecutionContext ec;

    private Logger log() {
        return this.log;
    }

    private ExecutionContext ec() {
        return this.ec;
    }

    public StructType resolveTable(ServerConnection conn, String table, Parameters.MergedParameters params) {
        return this.resolveTableFromMeta(conn, DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).tableMetaData(table), params);
    }

    public StructType resolveTableFromMeta(ServerConnection conn, ResultSetMetaData rsmd, Parameters.MergedParameters params) {
        int ncols = rsmd.getColumnCount();
        StructField[] fields = new StructField[ncols];
        for (int i = 0; i < ncols; ++i) {
            String columnName = rsmd.getColumnLabel(i + 1);
            int dataType = rsmd.getColumnType(i + 1);
            int fieldSize = rsmd.getPrecision(i + 1);
            int fieldScale = rsmd.getScale(i + 1);
            boolean isSigned = rsmd.isSigned(i + 1);
            boolean nullable = rsmd.isNullable(i + 1) != 0;
            DataType columnType = this.getCatalystType(dataType, fieldSize, fieldScale, isSigned);
            fields[i] = new StructField(params.keepOriginalColumnNameCase() ? columnName : (columnName.matches("[_A-Z]([_0-9A-Z])*") ? columnName : new StringBuilder(2).append("\"").append(columnName).append("\"").toString()), columnType, nullable, StructField$.MODULE$.apply$default$4());
        }
        return new StructType(fields);
    }

    public ServerConnection getConnector(Parameters.MergedParameters params) {
        return ServerConnection$.MODULE$.getServerConnection(params, ServerConnection$.MODULE$.getServerConnection$default$2());
    }

    public String schemaString(StructType schema, Parameters.MergedParameters param) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            String name = param.keepOriginalColumnNameCase() ? Utils$.MODULE$.quotedNameIgnoreCase(field.name()) : Utils$.MODULE$.ensureQuoted(field.name());
            String type = this.schemaConversion((StructField)field);
            String nullable = field.nullable() ? "" : "NOT NULL";
            return new StringBuilder(2).append(name).append(" ").append(type).append(" ").append(nullable).toString();
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
    }

    public String schemaConversion(StructField field) {
        String string;
        DataType dataType = field.dataType();
        if (IntegerType$.MODULE$.equals(dataType)) {
            string = "INTEGER";
        } else if (LongType$.MODULE$.equals(dataType)) {
            string = "INTEGER";
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            string = "DOUBLE";
        } else if (FloatType$.MODULE$.equals(dataType)) {
            string = "FLOAT";
        } else if (ShortType$.MODULE$.equals(dataType)) {
            string = "INTEGER";
        } else if (ByteType$.MODULE$.equals(dataType)) {
            string = "INTEGER";
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            string = "BOOLEAN";
        } else if (StringType$.MODULE$.equals(dataType)) {
            string = field.metadata().contains("maxlength") ? new StringBuilder(9).append("VARCHAR(").append(field.metadata().getLong("maxlength")).append(")").toString() : "STRING";
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            string = field.metadata().contains("maxlength") ? new StringBuilder(8).append("BINARY(").append(field.metadata().getLong("maxlength")).append(")").toString() : "BINARY";
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            string = "TIMESTAMP";
        } else if (DateType$.MODULE$.equals(dataType)) {
            string = "DATE";
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            string = new StringBuilder(10).append("DECIMAL(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString();
        } else {
            boolean bl = dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType);
            if (bl) {
                string = "VARIANT";
            } else {
                throw new IllegalArgumentException(new StringBuilder(45).append("Don't know how to save ").append(field).append(" of type ").append(field.name()).append(" to Snowflake").toString());
            }
        }
        return string;
    }

    public boolean tableExists(Parameters.MergedParameters params, String table) {
        boolean bl;
        try (ServerConnection conn = this.getConnector(params);){
            Object object = params.checkTableExistenceInCurrentSchemaOnly() ? BoxesRunTime.boxToBoolean((boolean)conn.createStatement().execute("alter session set search_path='$current'")) : BoxedUnit.UNIT;
            DefaultJDBCWrapper.DataBaseOperations qual$1 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
            String x$1 = table;
            boolean x$2 = qual$1.tableExists$default$2();
            bl = qual$1.tableExists(x$1, x$2);
        }
        return bl;
    }

    public boolean executePreparedInterruptibly(PreparedStatement statement) {
        return BoxesRunTime.unboxToBoolean(this.executeInterruptibly((Statement)statement, (Function1 & Serializable & scala.Serializable)stmt -> BoxesRunTime.boxToBoolean((boolean)JDBCWrapper.$anonfun$executePreparedInterruptibly$1(stmt))));
    }

    public boolean executePreparedInterruptibly(ServerConnection conn, String sql) {
        return this.executePreparedInterruptibly(conn.prepareStatement(sql));
    }

    public ResultSet executePreparedQueryInterruptibly(PreparedStatement statement) {
        return (ResultSet)this.executeInterruptibly((Statement)statement, (Function1 & Serializable & scala.Serializable)stmt -> {
            PreparedStatement prepStmt = (PreparedStatement)stmt;
            return prepStmt.executeQuery();
        });
    }

    public ResultSet executePreparedQueryAsyncInterruptibly(PreparedStatement statement) {
        return (ResultSet)this.executeInterruptibly((Statement)statement, (Function1 & Serializable & scala.Serializable)stmt -> {
            SnowflakePreparedStatement prepStmt = (SnowflakePreparedStatement)stmt;
            return prepStmt.executeAsyncQuery();
        });
    }

    public ResultSet executePreparedQueryInterruptibly(ServerConnection conn, String sql) {
        return this.executePreparedQueryInterruptibly(conn.prepareStatement(sql));
    }

    public ResultSet executeQueryInterruptibly(Statement statement, String str) {
        return (ResultSet)this.executeInterruptibly(statement, (Function1 & Serializable & scala.Serializable)x$1 -> x$1.executeQuery(str));
    }

    public boolean executeInterruptibly(Statement statement, String str) {
        return BoxesRunTime.unboxToBoolean(this.executeInterruptibly(statement, (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.execute(str))));
    }

    public ResultSet executeQueryInterruptibly(ServerConnection conn, String sql) {
        Statement stmt = conn.createStatement();
        return this.executeQueryInterruptibly(stmt, sql);
    }

    public boolean executeInterruptibly(ServerConnection conn, String sql) {
        Statement stmt = conn.createStatement();
        return this.executeInterruptibly(stmt, sql);
    }

    private <T> T executeInterruptibly(Statement statement, Function1<Statement, T> op) {
        Object object;
        try {
            this.log().debug(new StringBuilder(18).append("Running statement ").append(statement).toString());
            Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> op.apply((Object)statement), this.ec());
            object = Await$.MODULE$.result((Awaitable)future, (Duration)Duration$.MODULE$.Inf());
        }
        catch (InterruptedException e) {
            try {
                this.log().info(new StringBuilder(21).append("Cancelling statement ").append(statement).toString());
                statement.cancel();
                this.log().info("Cancelling succeeded");
                throw e;
            }
            catch (SQLException s) {
                this.log().error("Exception occurred while cancelling query", (Throwable)s);
                throw e;
            }
        }
        return (T)object;
    }

    private DataType getCatalystType(int sqlType, int precision, int scale, boolean signed) {
        BooleanType$ booleanType$;
        int n = sqlType;
        switch (n) {
            case 2003: {
                booleanType$ = null;
                break;
            }
            case -5: {
                if (signed) {
                    booleanType$ = LongType$.MODULE$;
                    break;
                }
                booleanType$ = new DecimalType(20, 0);
                break;
            }
            case 16: {
                booleanType$ = BooleanType$.MODULE$;
                break;
            }
            case 1: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 2005: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 70: {
                booleanType$ = null;
                break;
            }
            case 91: {
                booleanType$ = DateType$.MODULE$;
                break;
            }
            case 3: {
                if (precision != 0 || scale != 0) {
                    if (precision > DecimalType$.MODULE$.MAX_PRECISION()) {
                        booleanType$ = new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), scale + (precision - DecimalType$.MODULE$.MAX_SCALE()));
                        break;
                    }
                    booleanType$ = new DecimalType(precision, scale);
                    break;
                }
                booleanType$ = new DecimalType(38, 18);
                break;
            }
            case 2001: {
                booleanType$ = null;
                break;
            }
            case 8: {
                booleanType$ = DoubleType$.MODULE$;
                break;
            }
            case 6: {
                booleanType$ = FloatType$.MODULE$;
                break;
            }
            case 4: {
                if (signed) {
                    booleanType$ = IntegerType$.MODULE$;
                    break;
                }
                booleanType$ = LongType$.MODULE$;
                break;
            }
            case 2000: {
                booleanType$ = null;
                break;
            }
            case -16: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case -1: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case -15: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 2011: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 0: {
                booleanType$ = null;
                break;
            }
            case 2: {
                if (precision != 0 || scale != 0) {
                    booleanType$ = new DecimalType(precision, scale);
                    break;
                }
                booleanType$ = new DecimalType(38, 18);
                break;
            }
            case -9: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 1111: {
                booleanType$ = null;
                break;
            }
            case 7: {
                booleanType$ = DoubleType$.MODULE$;
                break;
            }
            case 2006: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case -8: {
                booleanType$ = LongType$.MODULE$;
                break;
            }
            case 5: {
                booleanType$ = IntegerType$.MODULE$;
                break;
            }
            case 2009: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 2002: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 92: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 93: {
                booleanType$ = TimestampType$.MODULE$;
                break;
            }
            case 2014: {
                booleanType$ = TimestampType$.MODULE$;
                break;
            }
            case -6: {
                booleanType$ = IntegerType$.MODULE$;
                break;
            }
            case 12: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case -2: {
                booleanType$ = BinaryType$.MODULE$;
                break;
            }
            default: {
                booleanType$ = null;
                break;
            }
        }
        BooleanType$ answer = booleanType$;
        if (answer == null) {
            throw new SQLException(new StringBuilder(17).append("Unsupported type ").append(sqlType).toString());
        }
        return answer;
    }

    public Telemetry getTelemetry(ServerConnection conn) {
        return TelemetryClient.createTelemetry((Connection)conn.jdbcConnection());
    }

    public static final /* synthetic */ boolean $anonfun$executePreparedInterruptibly$1(Statement stmt) {
        PreparedStatement prepStmt = (PreparedStatement)stmt;
        return prepStmt.execute();
    }

    public JDBCWrapper() {
        this.log().debug("Creating a new ExecutionContext");
        ThreadFactory threadFactory = new ThreadFactory(null){
            private final AtomicInteger count;

            /*
             * WARNING - void declaration
             */
            public Thread newThread(Runnable r) {
                void var2_2;
                Thread thread = new Thread(r);
                thread.setName(new StringBuilder(28).append("spark-snowflake-JDBCWrapper-").append(this.count.incrementAndGet()).toString());
                thread.setDaemon(true);
                return var2_2;
            }
            {
                this.count = new AtomicInteger();
            }
        };
        this.ec = ExecutionContext$.MODULE$.fromExecutorService(Executors.newCachedThreadPool(threadFactory));
    }
}

