/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.credential;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.LogLevel;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.LoggingEventBuilder;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Sinks;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class SimpleTokenCache {
    private static final Duration REFRESH_OFFSET = Duration.ofMinutes(5L);
    private static final ClientLogger LOGGER = new ClientLogger(SimpleTokenCache.class);
    private final AtomicReference<Sinks.One<AccessToken>> wip;
    private volatile AccessToken cache;
    private volatile OffsetDateTime nextTokenRefresh = OffsetDateTime.now();
    private final Supplier<Mono<AccessToken>> tokenSupplier;
    private final Predicate<AccessToken> shouldRefresh;
    private final Duration refreshDelay;
    private final String refreshDelayString;

    public SimpleTokenCache(Supplier<Mono<AccessToken>> tokenSupplier) {
        this(tokenSupplier, Duration.ofSeconds(30L));
    }

    SimpleTokenCache(Supplier<Mono<AccessToken>> tokenSupplier, Duration refreshDelay) {
        this.wip = new AtomicReference();
        this.tokenSupplier = tokenSupplier;
        this.shouldRefresh = accessToken -> OffsetDateTime.now().isAfter(accessToken.getRefreshAt() == null ? accessToken.getExpiresAt().minus(REFRESH_OFFSET) : accessToken.getRefreshAt());
        this.refreshDelay = refreshDelay;
        this.refreshDelayString = String.valueOf(refreshDelay.getSeconds());
    }

    public Mono<AccessToken> getToken() {
        return Mono.defer(() -> {
            try {
                if (this.wip.compareAndSet(null, Sinks.one())) {
                    Mono<AccessToken> fallback;
                    Mono<Object> tokenRefresh;
                    Sinks.One<AccessToken> sinksOne = this.wip.get();
                    OffsetDateTime now = OffsetDateTime.now();
                    if (this.cache != null && !this.shouldRefresh.test(this.cache)) {
                        tokenRefresh = Mono.empty();
                        fallback = Mono.just(this.cache);
                    } else if (this.cache == null || this.cache.isExpired()) {
                        tokenRefresh = now.isAfter(this.nextTokenRefresh) ? Mono.defer(this.tokenSupplier) : Mono.defer(this.tokenSupplier).delaySubscription(Duration.between(now, this.nextTokenRefresh));
                        fallback = Mono.empty();
                    } else {
                        tokenRefresh = now.isAfter(this.nextTokenRefresh) ? Mono.defer(this.tokenSupplier) : Mono.empty();
                        fallback = Mono.just(this.cache);
                    }
                    return Mono.using(() -> this.wip, ignored -> tokenRefresh.materialize().flatMap(signal -> {
                        AccessToken accessToken = (AccessToken)signal.get();
                        Throwable error = signal.getThrowable();
                        if (signal.isOnNext() && accessToken != null) {
                            this.buildTokenRefreshLog(LogLevel.INFORMATIONAL, this.cache, now).log("Acquired a new access token");
                            this.cache = accessToken;
                            sinksOne.tryEmitValue(accessToken);
                            this.nextTokenRefresh = OffsetDateTime.now().plus(this.refreshDelay);
                            return Mono.just(accessToken);
                        }
                        if (signal.isOnError() && error != null) {
                            this.buildTokenRefreshLog(LogLevel.ERROR, this.cache, now).log("Failed to acquire a new access token");
                            this.nextTokenRefresh = OffsetDateTime.now().plus(this.refreshDelay);
                            return fallback.switchIfEmpty(Mono.error(() -> error));
                        }
                        sinksOne.tryEmitEmpty();
                        return fallback;
                    }).doOnError(sinksOne::tryEmitError), w -> w.set(null));
                }
                if (this.cache != null && !this.cache.isExpired()) {
                    return Mono.just(this.cache);
                }
                Sinks.One<AccessToken> sinksOne = this.wip.get();
                if (sinksOne == null) {
                    return Mono.just(this.cache);
                }
                return sinksOne.asMono().switchIfEmpty(Mono.fromSupplier(() -> this.cache));
            }
            catch (Exception t) {
                return Mono.error(t);
            }
        });
    }

    Sinks.One<AccessToken> getWipValue() {
        return this.wip.get();
    }

    private LoggingEventBuilder buildTokenRefreshLog(LogLevel level, AccessToken cache, OffsetDateTime now) {
        LoggingEventBuilder logBuilder = LOGGER.atLevel(level);
        if (cache == null || !LOGGER.canLogAtLevel(level)) {
            return logBuilder;
        }
        Duration tte = Duration.between(now, cache.getExpiresAt());
        return logBuilder.addKeyValue("expiresAt", cache.getExpiresAt()).addKeyValue("tteSeconds", String.valueOf(tte.abs().getSeconds())).addKeyValue("retryAfterSeconds", this.refreshDelayString).addKeyValue("expired", tte.isNegative());
    }
}

