/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpClient;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineCallContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.http.HttpPipelineCallState;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.tracing.Tracer;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.List;
import java.util.Objects;

public final class HttpPipeline {
    private final HttpClient httpClient;
    private final HttpPipelinePolicy[] pipelinePolicies;
    private final Tracer tracer;

    HttpPipeline(HttpClient httpClient, List<HttpPipelinePolicy> pipelinePolicies, Tracer tracer) {
        Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
        Objects.requireNonNull(pipelinePolicies, "'pipelinePolicies' cannot be null.");
        this.httpClient = httpClient;
        this.pipelinePolicies = pipelinePolicies.toArray(new HttpPipelinePolicy[0]);
        this.tracer = tracer;
    }

    public HttpPipelinePolicy getPolicy(int index) {
        return this.pipelinePolicies[index];
    }

    public int getPolicyCount() {
        return this.pipelinePolicies.length;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        return this.send(new HttpPipelineCallContext(request));
    }

    public Mono<HttpResponse> send(HttpRequest request, Context data) {
        return this.send(new HttpPipelineCallContext(request, data));
    }

    public Mono<HttpResponse> send(HttpPipelineCallContext context) {
        return Mono.defer(() -> {
            HttpPipelineNextPolicy next = new HttpPipelineNextPolicy(new HttpPipelineCallState(this, context));
            return next.process();
        });
    }

    public HttpResponse sendSync(HttpRequest request, Context data) {
        HttpPipelineNextSyncPolicy next = new HttpPipelineNextSyncPolicy(new HttpPipelineCallState(this, new HttpPipelineCallContext(request, data)));
        return next.processSync();
    }
}

