/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.netty.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeader;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.netty.implementation.DeferredCacheImmutableMap;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class NettyToAzureCoreHttpHeadersWrapper
extends HttpHeaders {
    private static final ClientLogger LOGGER = new ClientLogger(NettyToAzureCoreHttpHeadersWrapper.class);
    private final com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpHeaders nettyHeaders;
    private Map<String, String> abstractMap;
    private Map<String, String[]> abstractMultiMap;

    public NettyToAzureCoreHttpHeadersWrapper(com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpHeaders nettyHeaders) {
        this.nettyHeaders = nettyHeaders;
    }

    @Override
    public int getSize() {
        return this.nettyHeaders.size();
    }

    @Override
    @Deprecated
    public HttpHeaders add(String name, String value) {
        this.nettyHeaders.add(name, (Object)value);
        return this;
    }

    @Override
    public HttpHeaders add(HttpHeaderName name, String value) {
        return this.add(name.getCaseSensitiveName(), value);
    }

    @Override
    @Deprecated
    public HttpHeaders set(String name, String value) {
        this.nettyHeaders.set(name, (Object)value);
        return this;
    }

    @Override
    public HttpHeaders set(HttpHeaderName name, String value) {
        return this.set(name.getCaseSensitiveName(), value);
    }

    @Override
    @Deprecated
    public HttpHeaders set(String name, List<String> values2) {
        this.nettyHeaders.set(name, (Iterable<?>)values2);
        return this;
    }

    @Override
    public HttpHeaders set(HttpHeaderName name, List<String> values2) {
        return this.set(name.getCaseSensitiveName(), values2);
    }

    @Override
    public HttpHeaders setAll(Map<String, List<String>> headers) {
        headers.forEach(this::set);
        return this;
    }

    @Override
    public HttpHeaders setAllHttpHeaders(HttpHeaders headers) {
        headers.forEach(header -> this.set(header.getName(), header.getValuesList()));
        return this;
    }

    @Override
    @Deprecated
    public HttpHeader get(String name) {
        List<String> values2 = this.nettyHeaders.getAll(name);
        return CoreUtils.isNullOrEmpty(values2) ? null : new NettyHttpHeader(this, name, values2);
    }

    @Override
    public HttpHeader get(HttpHeaderName name) {
        return this.get(name.getCaseSensitiveName());
    }

    @Override
    @Deprecated
    public HttpHeader remove(String name) {
        HttpHeader header = this.get(name);
        if (header != null) {
            this.nettyHeaders.remove(name);
        }
        return header;
    }

    @Override
    public HttpHeader remove(HttpHeaderName name) {
        return this.remove(name.getCaseSensitiveName());
    }

    @Override
    @Deprecated
    public String getValue(String name) {
        List<String> values2 = this.nettyHeaders.getAll(name);
        return CoreUtils.isNullOrEmpty(values2) ? null : CoreUtils.stringJoin(",", values2);
    }

    @Override
    public String getValue(HttpHeaderName name) {
        return this.getValue(name.getCaseSensitiveName());
    }

    @Override
    @Deprecated
    public String[] getValues(String name) {
        List<String> values2 = this.nettyHeaders.getAll(name);
        return CoreUtils.isNullOrEmpty(values2) ? null : values2.toArray(new String[0]);
    }

    @Override
    public String[] getValues(HttpHeaderName name) {
        return this.getValues(name.getCaseSensitiveName());
    }

    @Override
    public Map<String, String> toMap() {
        if (this.abstractMap == null) {
            this.abstractMap = new DeferredCacheImmutableMap<String>(LOGGER, new HashMap(), this.nettyHeaders, getAll -> CoreUtils.stringJoin(",", getAll));
        }
        return this.abstractMap;
    }

    Map<String, String[]> toMultiMap() {
        if (this.abstractMultiMap == null) {
            this.abstractMultiMap = new DeferredCacheImmutableMap<String[]>(LOGGER, new HashMap(), this.nettyHeaders, getAll -> getAll.toArray(new String[0]));
        }
        return this.abstractMultiMap;
    }

    @Override
    public Iterator<HttpHeader> iterator() {
        return new NettyHeadersIterator(this);
    }

    @Override
    public Stream<HttpHeader> stream() {
        return this.nettyHeaders.names().stream().map(name -> new NettyHttpHeader(this, (String)name, this.nettyHeaders.getAll((String)name)));
    }

    static class NettyHttpHeader
    extends HttpHeader {
        private final NettyToAzureCoreHttpHeadersWrapper allHeaders;

        NettyHttpHeader(NettyToAzureCoreHttpHeadersWrapper allHeaders, String name, String value) {
            super(name, value);
            this.allHeaders = allHeaders;
        }

        NettyHttpHeader(NettyToAzureCoreHttpHeadersWrapper allHeaders, String name, List<String> values2) {
            super(name, values2);
            this.allHeaders = allHeaders;
        }

        @Override
        public void addValue(String value) {
            super.addValue(value);
            this.allHeaders.add(this.getName(), value);
        }
    }

    static final class NettyHeadersIterator
    implements Iterator<HttpHeader> {
        private final NettyToAzureCoreHttpHeadersWrapper allHeaders;
        private final Iterator<String> headerNames;

        NettyHeadersIterator(NettyToAzureCoreHttpHeadersWrapper allHeaders) {
            this.allHeaders = allHeaders;
            this.headerNames = allHeaders.nettyHeaders.names().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.headerNames.hasNext();
        }

        @Override
        public NettyHttpHeader next() {
            String headerName = this.headerNames.next();
            return new NettyHttpHeader(this.allHeaders, headerName, this.allHeaders.nettyHeaders.getAll(headerName));
        }
    }
}

