/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpClient;
import com.dataiku.dss.shadelibazure.com.azure.core.http.ProxyOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.OkHttpAsyncHttpClient;
import com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.implementation.OkHttpProxySelector;
import com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.implementation.ProxyAuthenticator;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.HttpUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.okhttp3.ConnectionPool;
import com.dataiku.dss.shadelibazure.okhttp3.Dispatcher;
import com.dataiku.dss.shadelibazure.okhttp3.Interceptor;
import com.dataiku.dss.shadelibazure.okhttp3.OkHttpClient;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OkHttpAsyncHttpClientBuilder {
    private static final ClientLogger LOGGER = new ClientLogger(OkHttpAsyncHttpClientBuilder.class);
    private final OkHttpClient okHttpClient;
    private List<Interceptor> networkInterceptors = new ArrayList<Interceptor>();
    private Duration readTimeout;
    private Duration responseTimeout;
    private Duration writeTimeout;
    private Duration connectionTimeout;
    private Duration callTimeout;
    private ConnectionPool connectionPool;
    private Dispatcher dispatcher;
    private ProxyOptions proxyOptions;
    private Configuration configuration;
    private boolean followRedirects;

    public OkHttpAsyncHttpClientBuilder() {
        this.okHttpClient = null;
    }

    public OkHttpAsyncHttpClientBuilder(OkHttpClient okHttpClient) {
        this.okHttpClient = Objects.requireNonNull(okHttpClient, "'okHttpClient' cannot be null.");
    }

    public OkHttpAsyncHttpClientBuilder addNetworkInterceptor(Interceptor networkInterceptor) {
        Objects.requireNonNull(networkInterceptor, "'networkInterceptor' cannot be null.");
        this.networkInterceptors.add(networkInterceptor);
        return this;
    }

    public OkHttpAsyncHttpClientBuilder networkInterceptors(List<Interceptor> networkInterceptors) {
        this.networkInterceptors = Objects.requireNonNull(networkInterceptors, "'networkInterceptors' cannot be null.");
        return this;
    }

    public OkHttpAsyncHttpClientBuilder readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder responseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder writeTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder connectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder callTimeout(Duration callTimeout) {
        if (callTimeout != null && callTimeout.isNegative()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'callTimeout' cannot be negative"));
        }
        this.callTimeout = callTimeout;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder connectionPool(ConnectionPool connectionPool) {
        this.connectionPool = Objects.requireNonNull(connectionPool, "'connectionPool' cannot be null.");
        return this;
    }

    public OkHttpAsyncHttpClientBuilder dispatcher(Dispatcher dispatcher) {
        this.dispatcher = Objects.requireNonNull(dispatcher, "'dispatcher' cannot be null.");
        return this;
    }

    public OkHttpAsyncHttpClientBuilder proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public HttpClient build() {
        ProxyOptions buildProxyOptions;
        OkHttpClient.Builder httpClientBuilder = this.okHttpClient == null ? new OkHttpClient.Builder() : this.okHttpClient.newBuilder();
        for (Interceptor interceptor : this.networkInterceptors) {
            httpClientBuilder = httpClientBuilder.addNetworkInterceptor(interceptor);
        }
        httpClientBuilder = httpClientBuilder.connectTimeout(HttpUtils.getTimeout(this.connectionTimeout, HttpUtils.getDefaultConnectTimeout())).writeTimeout(HttpUtils.getTimeout(this.writeTimeout, HttpUtils.getDefaultWriteTimeout())).readTimeout(HttpUtils.getTimeout(this.readTimeout, HttpUtils.getDefaultReadTimeout()));
        if (this.callTimeout != null) {
            httpClientBuilder.callTimeout(this.callTimeout);
        }
        if (this.connectionPool != null) {
            httpClientBuilder = httpClientBuilder.connectionPool(this.connectionPool);
        }
        if (this.dispatcher != null) {
            httpClientBuilder = httpClientBuilder.dispatcher(this.dispatcher);
        }
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        ProxyOptions proxyOptions = buildProxyOptions = this.proxyOptions == null ? ProxyOptions.fromConfiguration(buildConfiguration, true) : this.proxyOptions;
        if (buildProxyOptions != null) {
            httpClientBuilder = httpClientBuilder.proxySelector(new OkHttpProxySelector(buildProxyOptions.getType().toProxyType(), buildProxyOptions::getAddress, buildProxyOptions.getNonProxyHosts()));
            if (buildProxyOptions.getUsername() != null) {
                ProxyAuthenticator proxyAuthenticator = new ProxyAuthenticator(buildProxyOptions.getUsername(), buildProxyOptions.getPassword());
                httpClientBuilder = httpClientBuilder.proxyAuthenticator(proxyAuthenticator).addInterceptor(proxyAuthenticator.getProxyAuthenticationInfoInterceptor());
            }
        }
        httpClientBuilder.followRedirects(this.followRedirects);
        return new OkHttpAsyncHttpClient(httpClientBuilder.build(), HttpUtils.getTimeout(this.responseTimeout, HttpUtils.getDefaultResponseTimeout()));
    }
}

