/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.policy;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineCallContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.AccessTokenCache;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.http.policy.AuthorizationChallengeParser;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;

public class BearerTokenAuthenticationPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(BearerTokenAuthenticationPolicy.class);
    private static final String BEARER = "Bearer";
    private final String[] scopes;
    private final AccessTokenCache cache;

    public BearerTokenAuthenticationPolicy(TokenCredential credential, String ... scopes) {
        Objects.requireNonNull(credential);
        this.scopes = scopes;
        this.cache = new AccessTokenCache(credential);
    }

    public Mono<Void> authorizeRequest(HttpPipelineCallContext context) {
        if (this.scopes == null) {
            return Mono.empty();
        }
        return this.setAuthorizationHeaderHelper(context, new TokenRequestContext().addScopes(this.scopes).setCaeEnabled(true), false);
    }

    public void authorizeRequestSync(HttpPipelineCallContext context) {
        this.setAuthorizationHeaderHelperSync(context, new TokenRequestContext().addScopes(this.scopes).setCaeEnabled(true), false);
    }

    public Mono<Boolean> authorizeRequestOnChallenge(HttpPipelineCallContext context, HttpResponse response) {
        TokenRequestContext tokenRequestContext;
        if (AuthorizationChallengeParser.isCaeClaimsChallenge(response) && (tokenRequestContext = this.getTokenRequestContextForCaeChallenge(response)) != null) {
            return this.setAuthorizationHeader(context, tokenRequestContext).then(Mono.just(true));
        }
        return Mono.just(false);
    }

    public boolean authorizeRequestOnChallengeSync(HttpPipelineCallContext context, HttpResponse response) {
        TokenRequestContext tokenRequestContext;
        if (AuthorizationChallengeParser.isCaeClaimsChallenge(response) && (tokenRequestContext = this.getTokenRequestContextForCaeChallenge(response)) != null) {
            this.setAuthorizationHeaderSync(context, tokenRequestContext);
            return true;
        }
        return false;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if (!"https".equals(context.getHttpRequest().getUrl().getProtocol())) {
            return Mono.error(new RuntimeException("token credentials require a URL using the HTTPS protocol scheme"));
        }
        HttpPipelineNextPolicy nextPolicy = next.clone();
        return this.authorizeRequest(context).then(Mono.defer(next::process)).flatMap(httpResponse -> {
            String authHeader = httpResponse.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
            if (httpResponse.getStatusCode() == 401 && authHeader != null) {
                return this.authorizeRequestOnChallenge(context, (HttpResponse)httpResponse).flatMap(authorized -> {
                    if (authorized.booleanValue()) {
                        httpResponse.close();
                        return nextPolicy.process();
                    }
                    return Mono.just(httpResponse);
                });
            }
            return Mono.just(httpResponse);
        });
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        if (!"https".equals(context.getHttpRequest().getUrl().getProtocol())) {
            throw LOGGER.logExceptionAsError(new RuntimeException("token credentials require a URL using the HTTPS protocol scheme"));
        }
        HttpPipelineNextSyncPolicy nextPolicy = next.clone();
        this.authorizeRequestSync(context);
        HttpResponse httpResponse = next.processSync();
        String authHeader = httpResponse.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
        if (httpResponse.getStatusCode() == 401 && authHeader != null) {
            if (this.authorizeRequestOnChallengeSync(context, httpResponse)) {
                httpResponse.close();
                return nextPolicy.processSync();
            }
            return httpResponse;
        }
        return httpResponse;
    }

    public Mono<Void> setAuthorizationHeader(HttpPipelineCallContext context, TokenRequestContext tokenRequestContext) {
        return this.setAuthorizationHeaderHelper(context, tokenRequestContext, true);
    }

    public void setAuthorizationHeaderSync(HttpPipelineCallContext context, TokenRequestContext tokenRequestContext) {
        this.setAuthorizationHeaderHelperSync(context, tokenRequestContext, true);
    }

    private Mono<Void> setAuthorizationHeaderHelper(HttpPipelineCallContext context, TokenRequestContext tokenRequestContext, boolean checkToForceFetchToken) {
        return this.cache.getToken(tokenRequestContext, checkToForceFetchToken).flatMap(token -> {
            BearerTokenAuthenticationPolicy.setAuthorizationHeader(context.getHttpRequest().getHeaders(), token.getToken());
            return Mono.empty();
        });
    }

    private void setAuthorizationHeaderHelperSync(HttpPipelineCallContext context, TokenRequestContext tokenRequestContext, boolean checkToForceFetchToken) {
        AccessToken token = this.cache.getTokenSync(tokenRequestContext, checkToForceFetchToken);
        BearerTokenAuthenticationPolicy.setAuthorizationHeader(context.getHttpRequest().getHeaders(), token.getToken());
    }

    private static void setAuthorizationHeader(HttpHeaders headers, String token) {
        headers.set(HttpHeaderName.AUTHORIZATION, "Bearer " + token);
    }

    private TokenRequestContext getTokenRequestContextForCaeChallenge(HttpResponse response) {
        String decodedClaims = null;
        String encodedClaims = AuthorizationChallengeParser.getChallengeParameterFromResponse(response, BEARER, "claims");
        if (!CoreUtils.isNullOrEmpty(encodedClaims)) {
            try {
                decodedClaims = new String(Base64.getDecoder().decode(encodedClaims), StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warning("Failed to decode the claims from the CAE challenge. Encoded claims: " + encodedClaims);
            }
        }
        if (decodedClaims == null) {
            return null;
        }
        return new TokenRequestContext().setClaims(decodedClaims).addScopes(this.scopes).setCaeEnabled(true);
    }
}

