/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.policy;

import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.FixedDelayOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RequestRetryCondition;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryStrategy;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.accesshelpers.FixedDelayAccessHelper;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Predicate;

public class FixedDelay
implements RetryStrategy {
    private static final ClientLogger LOGGER = new ClientLogger(FixedDelay.class);
    private final int maxRetries;
    private final Duration delay;
    private final Predicate<RequestRetryCondition> shouldRetryCondition;

    public FixedDelay(int maxRetries, Duration delay) {
        this(maxRetries, delay, null);
    }

    public FixedDelay(FixedDelayOptions fixedDelayOptions) {
        this(Objects.requireNonNull(fixedDelayOptions, "'fixedDelayOptions' cannot be null.").getMaxRetries(), Objects.requireNonNull(fixedDelayOptions, "'fixedDelayOptions' cannot be null.").getDelay());
    }

    private FixedDelay(FixedDelayOptions fixedDelayOptions, Predicate<RequestRetryCondition> shouldRetryCondition) {
        this(Objects.requireNonNull(fixedDelayOptions, "'fixedDelayOptions' cannot be null.").getMaxRetries(), Objects.requireNonNull(fixedDelayOptions, "'fixedDelayOptions' cannot be null.").getDelay(), shouldRetryCondition);
    }

    private FixedDelay(int maxRetries, Duration delay, Predicate<RequestRetryCondition> shouldRetryCondition) {
        if (maxRetries < 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Max retries cannot be less than 0."));
        }
        this.maxRetries = maxRetries;
        this.delay = Objects.requireNonNull(delay, "'delay' cannot be null.");
        this.shouldRetryCondition = shouldRetryCondition;
    }

    @Override
    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public Duration calculateRetryDelay(int retryAttempts) {
        return this.delay;
    }

    @Override
    public boolean shouldRetryCondition(RequestRetryCondition requestRetryCondition) {
        return this.shouldRetryCondition == null ? RetryStrategy.super.shouldRetryCondition(requestRetryCondition) : this.shouldRetryCondition.test(requestRetryCondition);
    }

    static {
        FixedDelayAccessHelper.setAccessor(FixedDelay::new);
    }
}

