/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.implementation.logging;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import java.util.Arrays;

public final class LoggingUtils {
    private static final char CR = '\r';
    private static final char LF = '\n';

    private LoggingUtils() {
    }

    public static String removeNewLinesFromLogMessage(String logMessage) {
        if (CoreUtils.isNullOrEmpty(logMessage)) {
            return logMessage;
        }
        StringBuilder sb = null;
        int prevStart = 0;
        for (int i = 0; i < logMessage.length(); ++i) {
            if (logMessage.charAt(i) != '\r' && logMessage.charAt(i) != '\n') continue;
            if (sb == null) {
                sb = new StringBuilder(logMessage.length());
            }
            if (prevStart != i) {
                sb.append(logMessage, prevStart, i);
            }
            prevStart = i + 1;
        }
        if (sb == null) {
            return logMessage;
        }
        sb.append(logMessage, prevStart, logMessage.length());
        return sb.toString();
    }

    public static boolean doesArgsHaveThrowable(Object ... args2) {
        if (args2.length == 0) {
            return false;
        }
        return args2[args2.length - 1] instanceof Throwable;
    }

    public static Object[] removeThrowable(Object ... args2) {
        return Arrays.copyOf(args2, args2.length - 1);
    }
}

