/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.implementation.util;

import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.ReferenceManagerImpl;
import java.lang.ref.PhantomReference;

final class CleanableReference<T>
extends PhantomReference<T> {
    private final Runnable cleanupAction;
    private final CleanableReference<?> cleanupList;
    CleanableReference<?> previous = this;
    CleanableReference<?> next = this;

    CleanableReference() {
        super(null, null);
        this.cleanupAction = null;
        this.cleanupList = this;
    }

    CleanableReference(T referent, Runnable cleanupAction, ReferenceManagerImpl manager) {
        super(referent, manager.getQueue());
        this.cleanupAction = cleanupAction;
        this.cleanupList = manager.getCleanableReferenceList();
        this.insert();
    }

    public void clean() {
        if (this.remove()) {
            super.clear();
            this.cleanupAction.run();
        }
    }

    @Override
    public void clear() {
        if (this.remove()) {
            super.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasRemaining() {
        CleanableReference<?> cleanableReference = this.cleanupList;
        synchronized (cleanableReference) {
            return this.cleanupList != this.cleanupList.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert() {
        CleanableReference<?> cleanableReference = this.cleanupList;
        synchronized (cleanableReference) {
            this.previous = this.cleanupList;
            this.next = this.cleanupList.next;
            this.next.previous = this;
            this.cleanupList.next = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove() {
        CleanableReference<?> cleanableReference = this.cleanupList;
        synchronized (cleanableReference) {
            if (this.next != this) {
                this.next.previous = this.previous;
                this.previous.next = this.next;
                this.previous = this;
                this.next = this;
                return true;
            }
            return false;
        }
    }
}

