/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Context {
    private static final ClientLogger LOGGER = new ClientLogger(Context.class);
    private static final Context[] EMPTY_CHAIN = new Context[0];
    public static final Context NONE = new Context(null, null, null, 0){

        @Override
        public Optional<Object> getData(Object key) {
            if (key == null) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("key cannot be null"));
            }
            return Optional.empty();
        }

        @Override
        public Map<Object, Object> getValues() {
            return Collections.emptyMap();
        }

        @Override
        Context[] getContextChain() {
            return EMPTY_CHAIN;
        }
    };
    private final Context parent;
    private final Object key;
    private final Object value;
    private final int contextCount;
    private Map<Object, Object> valuesMap;

    public Context(Object key, Object value) {
        this.parent = null;
        this.key = Objects.requireNonNull(key, "'key' cannot be null.");
        this.value = value;
        this.contextCount = 1;
    }

    private Context(Context parent, Object key, Object value, int contextCount) {
        this.parent = parent;
        this.key = key;
        this.value = value;
        this.contextCount = contextCount;
    }

    Object getKey() {
        return this.key;
    }

    Object getValue() {
        return this.value;
    }

    public Context addData(Object key, Object value) {
        if (key == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("key cannot be null"));
        }
        return new Context(this, key, value, this.contextCount + 1);
    }

    public static Context of(Map<Object, Object> keyValues) {
        if (CoreUtils.isNullOrEmpty(keyValues)) {
            throw new IllegalArgumentException("Key value map cannot be null or empty");
        }
        Context context = null;
        for (Map.Entry<Object, Object> entry : keyValues.entrySet()) {
            if (context == null) {
                context = new Context(entry.getKey(), entry.getValue());
                continue;
            }
            context = context.addData(entry.getKey(), entry.getValue());
        }
        return context;
    }

    public Optional<Object> getData(Object key) {
        if (key == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("key cannot be null"));
        }
        Context c = this;
        while (c != null) {
            if (key.equals(c.key)) {
                return Optional.ofNullable(c.value);
            }
            if (c.contextCount == 1) {
                return Optional.empty();
            }
            c = c.parent;
        }
        return Optional.empty();
    }

    public Map<Object, Object> getValues() {
        if (this.valuesMap != null) {
            return this.valuesMap;
        }
        if (this.contextCount == 1) {
            this.valuesMap = Collections.singletonMap(this.key, this.value);
            return this.valuesMap;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>((int)Math.ceil((float)this.contextCount / 0.75f));
        Context pointer = this;
        while (pointer != null) {
            if (pointer.key != null) {
                map.putIfAbsent(pointer.key, pointer.value);
            }
            if (pointer.contextCount == 1) break;
            pointer = pointer.parent;
        }
        this.valuesMap = Collections.unmodifiableMap(map);
        return this.valuesMap;
    }

    Context[] getContextChain() {
        Context[] chain = new Context[this.contextCount];
        int chainPosition = this.contextCount - 1;
        Context pointer = this;
        while (pointer != null) {
            chain[chainPosition--] = pointer;
            if (pointer.contextCount == 1) break;
            pointer = pointer.parent;
        }
        return chain;
    }
}

