/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util.io;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.StreamResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.AsynchronousFileChannelAdapter;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.ByteCountingAsynchronousByteChannel;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.ImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.ProgressReporter;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.LogLevel;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.LoggingEventBuilder;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.MonoSink;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import java.util.function.BiFunction;

public final class IOUtils {
    private static final ClientLogger LOGGER = new ClientLogger(IOUtils.class);
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int SIXTY_FOUR_KB = 65536;
    private static final int THIRTY_TWO_KB = 32768;
    private static final int MB = 0x100000;
    private static final int GB = 0x40000000;

    public static AsynchronousByteChannel toAsynchronousByteChannel(AsynchronousFileChannel fileChannel, long position) {
        Objects.requireNonNull(fileChannel, "'fileChannel' must not be null");
        if (position < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'position' cannot be less than 0."));
        }
        return new AsynchronousFileChannelAdapter(fileChannel, position);
    }

    public static void transfer(ReadableByteChannel source2, WritableByteChannel destination) throws IOException {
        IOUtils.transfer(source2, destination, null);
    }

    public static void transfer(ReadableByteChannel source2, WritableByteChannel destination, Long estimatedSourceSize) throws IOException {
        int read;
        if (source2 == null && destination == null) {
            throw new NullPointerException("'source' and 'destination' cannot be null.");
        }
        if (source2 == null) {
            throw new NullPointerException("'source' cannot be null.");
        }
        if (destination == null) {
            throw new NullPointerException("'destination' cannot be null.");
        }
        int bufferSize = estimatedSourceSize == null ? IOUtils.getBufferSize(source2) : IOUtils.getBufferSize(estimatedSourceSize);
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        do {
            buffer.clear();
            read = source2.read(buffer);
            buffer.flip();
            ImplUtils.fullyWriteBuffer(buffer, destination);
        } while (read >= 0);
    }

    public static Mono<Void> transferAsync(ReadableByteChannel source2, AsynchronousByteChannel destination) {
        return IOUtils.transferAsync(source2, destination, null);
    }

    public static Mono<Void> transferAsync(ReadableByteChannel source2, AsynchronousByteChannel destination, Long estimatedSourceSize) {
        if (source2 == null && destination == null) {
            return Mono.error(new NullPointerException("'source' and 'destination' cannot be null."));
        }
        if (source2 == null) {
            return Mono.error(new NullPointerException("'source' cannot be null."));
        }
        if (destination == null) {
            return Mono.error(new NullPointerException("'destination' cannot be null."));
        }
        int bufferSize = estimatedSourceSize == null ? IOUtils.getBufferSize(source2) : IOUtils.getBufferSize(estimatedSourceSize);
        return Mono.create(sink2 -> sink2.onRequest(value -> {
            ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
            try {
                IOUtils.transferAsynchronously(source2, destination, buffer, sink2);
            }
            catch (IOException e) {
                sink2.error(e);
            }
        }));
    }

    private static void transferAsynchronously(final ReadableByteChannel source2, final AsynchronousByteChannel destination, final ByteBuffer buffer, final MonoSink<Void> sink2) throws IOException {
        buffer.clear();
        int read = source2.read(buffer);
        if (read >= 0) {
            buffer.flip();
            destination.write(buffer, buffer, new CompletionHandler<Integer, ByteBuffer>(){

                @Override
                public void completed(Integer result, ByteBuffer attachment) {
                    try {
                        if (buffer.hasRemaining()) {
                            destination.write(buffer, buffer, this);
                        } else {
                            IOUtils.transferAsynchronously(source2, destination, buffer, sink2);
                        }
                    }
                    catch (IOException e) {
                        sink2.error(e);
                    }
                }

                @Override
                public void failed(Throwable e, ByteBuffer attachment) {
                    sink2.error(e);
                }
            });
        } else {
            sink2.success();
        }
    }

    public static Mono<Void> transferStreamResponseToAsynchronousByteChannel(AsynchronousByteChannel targetChannel, StreamResponse sourceResponse, BiFunction<Throwable, Long, Mono<StreamResponse>> onErrorResume, ProgressReporter progressReporter, int maxRetries) {
        return IOUtils.transferStreamResponseToAsynchronousByteChannelHelper(new ByteCountingAsynchronousByteChannel(targetChannel, null, progressReporter), sourceResponse, onErrorResume, maxRetries, 0);
    }

    private static Mono<Void> transferStreamResponseToAsynchronousByteChannelHelper(ByteCountingAsynchronousByteChannel targetChannel, StreamResponse response, BiFunction<Throwable, Long, Mono<StreamResponse>> onErrorResume, int maxRetries, int retryCount) {
        return Mono.using(() -> response, r -> r.writeValueToAsync(targetChannel).onErrorResume(Exception.class, exception -> {
            response.close();
            int updatedRetryCount = retryCount + 1;
            if (updatedRetryCount > maxRetries) {
                IOUtils.createBasicLoggingContext(LogLevel.ERROR, response).addKeyValue("tryCount", retryCount).log("Retry attempts have been exhausted.", exception);
                return Mono.error(exception);
            }
            long bytesWritten = targetChannel.getBytesWritten();
            IOUtils.createBasicLoggingContext(LogLevel.INFORMATIONAL, response).addKeyValue("tryCount", retryCount).addKeyValue("maxRetries", maxRetries).addKeyValue("bytesWritten", bytesWritten).log("Attempt failed. Scheduling retry.", exception);
            return ((Mono)onErrorResume.apply((Throwable)exception, bytesWritten)).flatMap(newResponse -> IOUtils.transferStreamResponseToAsynchronousByteChannelHelper(targetChannel, newResponse, onErrorResume, maxRetries, updatedRetryCount));
        }), StreamResponse::close);
    }

    private static int getBufferSize(ReadableByteChannel source2) {
        if (!(source2 instanceof SeekableByteChannel)) {
            return 8192;
        }
        SeekableByteChannel seekableSource = (SeekableByteChannel)source2;
        try {
            long size = seekableSource.size();
            long position = seekableSource.position();
            return IOUtils.getBufferSize(size - position);
        }
        catch (IOException ex) {
            return 8192;
        }
    }

    private static int getBufferSize(long dataSize) {
        if (dataSize > 0x40000000L) {
            return 65536;
        }
        if (dataSize > 0x100000L) {
            return 32768;
        }
        return 8192;
    }

    private static LoggingEventBuilder createBasicLoggingContext(LogLevel level, StreamResponse response) {
        LoggingEventBuilder log = LOGGER.atLevel(level);
        if (LOGGER.canLogAtLevel(level)) {
            String traceparent;
            String clientRequestId = response.getRequest().getHeaders().getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
            if (clientRequestId != null) {
                log.addKeyValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID.getCaseInsensitiveName(), clientRequestId);
            }
            if ((traceparent = response.getRequest().getHeaders().getValue(HttpHeaderName.TRACEPARENT)) != null) {
                log.addKeyValue(HttpHeaderName.TRACEPARENT.getCaseInsensitiveName(), traceparent);
            }
        }
        return log;
    }

    private IOUtils() {
    }
}

