/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util.logging;

import com.dataiku.dss.shadelibazure.com.azure.core.implementation.accesshelpers.ClientLoggerAccessHelper;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.logging.DefaultLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.logging.LoggingUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.LogLevel;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.LoggingEventBuilder;
import com.dataiku.dss.shadelibazure.org.slf4j.Logger;
import com.dataiku.dss.shadelibazure.org.slf4j.LoggerFactory;
import com.dataiku.dss.shadelibazure.org.slf4j.helpers.NOPLogger;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class ClientLogger {
    private final Logger logger;
    private final Map<String, Object> globalContext;
    private final boolean hasGlobalContext;

    public ClientLogger(Class<?> clazz) {
        this(clazz.getName());
    }

    public ClientLogger(String className) {
        this(className, Collections.emptyMap());
    }

    public ClientLogger(Class<?> clazz, Map<String, Object> context) {
        this(clazz.getName(), context);
    }

    public ClientLogger(String className, Map<String, Object> context) {
        this(ClientLogger.getLogger(className), context);
    }

    private static Logger getLogger(String className) {
        Logger initLogger = LoggerFactory.getLogger(className);
        return initLogger instanceof NOPLogger ? new DefaultLogger(className) : initLogger;
    }

    ClientLogger(Logger logger, Map<String, Object> context) {
        this.logger = logger;
        this.globalContext = context == null ? null : Collections.unmodifiableMap(context);
        this.hasGlobalContext = !CoreUtils.isNullOrEmpty(this.globalContext);
    }

    public void log(LogLevel logLevel, Supplier<String> message) {
        this.log(logLevel, message, null);
    }

    public void log(LogLevel logLevel, Supplier<String> message, Throwable throwable) {
        if (message != null && this.canLogAtLevel(logLevel)) {
            this.performDeferredLogging(logLevel, message, throwable);
        }
    }

    public void verbose(String message) {
        if (this.logger.isDebugEnabled()) {
            if (this.hasGlobalContext) {
                this.atVerbose().log(message);
            } else {
                this.logger.debug(LoggingUtils.removeNewLinesFromLogMessage(message));
            }
        }
    }

    public void verbose(String format, Object ... args2) {
        if (this.logger.isDebugEnabled()) {
            this.performLogging(LogLevel.VERBOSE, false, format, args2);
        }
    }

    public void info(String message) {
        if (this.logger.isInfoEnabled()) {
            if (this.hasGlobalContext) {
                this.atInfo().log(message);
            } else {
                this.logger.info(LoggingUtils.removeNewLinesFromLogMessage(message));
            }
        }
    }

    public void info(String format, Object ... args2) {
        if (this.logger.isInfoEnabled()) {
            this.performLogging(LogLevel.INFORMATIONAL, false, format, args2);
        }
    }

    public void warning(String message) {
        if (this.logger.isWarnEnabled()) {
            if (this.hasGlobalContext) {
                this.atWarning().log(message);
            } else {
                this.logger.warn(LoggingUtils.removeNewLinesFromLogMessage(message));
            }
        }
    }

    public void warning(String format, Object ... args2) {
        if (this.logger.isWarnEnabled()) {
            this.performLogging(LogLevel.WARNING, false, format, args2);
        }
    }

    public void error(String message) {
        if (this.logger.isErrorEnabled()) {
            if (this.hasGlobalContext) {
                this.atError().log(message);
            } else {
                this.logger.error(LoggingUtils.removeNewLinesFromLogMessage(message));
            }
        }
    }

    public void error(String format, Object ... args2) {
        if (this.logger.isErrorEnabled()) {
            this.performLogging(LogLevel.ERROR, false, format, args2);
        }
    }

    public RuntimeException logExceptionAsWarning(RuntimeException runtimeException) {
        Objects.requireNonNull(runtimeException, "'runtimeException' cannot be null.");
        return this.logThrowableAsWarning(runtimeException);
    }

    @Deprecated
    public <T extends Throwable> T logThowableAsWarning(T throwable) {
        Objects.requireNonNull(throwable, "'throwable' cannot be null.");
        if (!this.logger.isWarnEnabled()) {
            return throwable;
        }
        this.performLogging(LogLevel.WARNING, true, throwable.getMessage(), throwable);
        return throwable;
    }

    public <T extends Throwable> T logThrowableAsWarning(T throwable) {
        Objects.requireNonNull(throwable, "'throwable' cannot be null.");
        if (this.logger.isWarnEnabled()) {
            this.performLogging(LogLevel.WARNING, true, throwable.getMessage(), throwable);
        }
        return throwable;
    }

    public RuntimeException logExceptionAsError(RuntimeException runtimeException) {
        Objects.requireNonNull(runtimeException, "'runtimeException' cannot be null.");
        return this.logThrowableAsError(runtimeException);
    }

    public <T extends Throwable> T logThrowableAsError(T throwable) {
        Objects.requireNonNull(throwable, "'throwable' cannot be null.");
        if (!this.logger.isErrorEnabled()) {
            return throwable;
        }
        this.performLogging(LogLevel.ERROR, true, throwable.getMessage(), throwable);
        return throwable;
    }

    private void performLogging(LogLevel logLevel, boolean isExceptionLogging, String format, Object ... args2) {
        if (this.hasGlobalContext) {
            LoggingEventBuilder.create(this.logger, logLevel, this.globalContext, true).log(format, args2);
            return;
        }
        String throwableMessage = "";
        if (LoggingUtils.doesArgsHaveThrowable(args2)) {
            Object throwable;
            if (!isExceptionLogging && (throwable = args2[args2.length - 1]) instanceof Throwable) {
                throwableMessage = ((Throwable)throwable).getMessage();
            }
            if (!this.logger.isDebugEnabled()) {
                args2 = LoggingUtils.removeThrowable(args2);
            }
        }
        format = LoggingUtils.removeNewLinesFromLogMessage(format);
        switch (logLevel) {
            case VERBOSE: {
                this.logger.debug(format, args2);
                break;
            }
            case INFORMATIONAL: {
                this.logger.info(format, args2);
                break;
            }
            case WARNING: {
                if (!CoreUtils.isNullOrEmpty(throwableMessage)) {
                    format = format + System.lineSeparator() + throwableMessage;
                }
                this.logger.warn(format, args2);
                break;
            }
            case ERROR: {
                if (!CoreUtils.isNullOrEmpty(throwableMessage)) {
                    format = format + System.lineSeparator() + throwableMessage;
                }
                this.logger.error(format, args2);
                break;
            }
        }
    }

    private void performDeferredLogging(LogLevel logLevel, Supplier<String> messageSupplier, Throwable throwable) {
        if (this.hasGlobalContext) {
            LoggingEventBuilder.create(this.logger, logLevel, this.globalContext, true).log(messageSupplier, throwable);
            return;
        }
        String message = LoggingUtils.removeNewLinesFromLogMessage(messageSupplier.get());
        String throwableMessage = throwable != null ? throwable.getMessage() : "";
        switch (logLevel) {
            case VERBOSE: {
                if (throwable != null) {
                    this.logger.debug(message, throwable);
                    break;
                }
                this.logger.debug(message);
                break;
            }
            case INFORMATIONAL: {
                this.logger.info(message);
                break;
            }
            case WARNING: {
                if (!CoreUtils.isNullOrEmpty(throwableMessage)) {
                    message = message + System.lineSeparator() + throwableMessage;
                }
                this.logger.warn(message);
                break;
            }
            case ERROR: {
                if (!CoreUtils.isNullOrEmpty(throwableMessage)) {
                    message = message + System.lineSeparator() + throwableMessage;
                }
                this.logger.error(message);
                break;
            }
        }
    }

    Object[] evaluateSupplierArgument(Object[] args2) {
        if (this.isSupplierLogging(args2)) {
            args2[0] = ((Supplier)args2[0]).get();
        }
        return args2;
    }

    boolean isSupplierLogging(Object[] args2) {
        return args2.length == 1 && args2[0] instanceof Supplier || args2.length == 2 && args2[0] instanceof Supplier && (args2[1] instanceof Throwable || args2[1] == null);
    }

    public boolean canLogAtLevel(LogLevel logLevel) {
        if (logLevel == null) {
            return false;
        }
        switch (logLevel) {
            case VERBOSE: {
                return this.logger.isDebugEnabled();
            }
            case INFORMATIONAL: {
                return this.logger.isInfoEnabled();
            }
            case WARNING: {
                return this.logger.isWarnEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
        }
        return false;
    }

    public LoggingEventBuilder atError() {
        return LoggingEventBuilder.create(this.logger, LogLevel.ERROR, this.globalContext, this.canLogAtLevel(LogLevel.ERROR));
    }

    public LoggingEventBuilder atWarning() {
        return LoggingEventBuilder.create(this.logger, LogLevel.WARNING, this.globalContext, this.canLogAtLevel(LogLevel.WARNING));
    }

    public LoggingEventBuilder atInfo() {
        return LoggingEventBuilder.create(this.logger, LogLevel.INFORMATIONAL, this.globalContext, this.canLogAtLevel(LogLevel.INFORMATIONAL));
    }

    public LoggingEventBuilder atVerbose() {
        return LoggingEventBuilder.create(this.logger, LogLevel.VERBOSE, this.globalContext, this.canLogAtLevel(LogLevel.VERBOSE));
    }

    public LoggingEventBuilder atLevel(LogLevel level) {
        return LoggingEventBuilder.create(this.logger, level, this.globalContext, this.canLogAtLevel(level));
    }

    static {
        ClientLoggerAccessHelper.setAccessor(ClientLogger::new);
    }
}

