/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util.polling;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.serializer.DefaultJsonSerializer;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.ChainedPollingStrategy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.LocationPollingStrategy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.OperationResourcePollingStrategy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollingContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollingStrategy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollingStrategyOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.StatusCheckPollingStrategy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.JsonSerializer;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.TypeReference;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Arrays;
import java.util.Objects;

public final class DefaultPollingStrategy<T, U>
implements PollingStrategy<T, U> {
    private final ChainedPollingStrategy<T, U> chainedPollingStrategy;

    public DefaultPollingStrategy(HttpPipeline httpPipeline) {
        this(httpPipeline, new DefaultJsonSerializer(), Context.NONE);
    }

    public DefaultPollingStrategy(HttpPipeline httpPipeline, JsonSerializer serializer) {
        this(httpPipeline, serializer, Context.NONE);
    }

    public DefaultPollingStrategy(HttpPipeline httpPipeline, JsonSerializer serializer, Context context) {
        this(httpPipeline, null, serializer, context);
    }

    public DefaultPollingStrategy(HttpPipeline httpPipeline, String endpoint, JsonSerializer serializer, Context context) {
        this(new PollingStrategyOptions(httpPipeline).setEndpoint(endpoint).setSerializer(serializer).setContext(context));
    }

    public DefaultPollingStrategy(PollingStrategyOptions pollingStrategyOptions) {
        Objects.requireNonNull(pollingStrategyOptions, "'pollingStrategyOptions' cannot be null");
        this.chainedPollingStrategy = new ChainedPollingStrategy(Arrays.asList(new OperationResourcePollingStrategy(null, pollingStrategyOptions), new LocationPollingStrategy(pollingStrategyOptions), new StatusCheckPollingStrategy(pollingStrategyOptions.getSerializer())));
    }

    @Override
    public Mono<U> getResult(PollingContext<T> context, TypeReference<U> resultType) {
        return this.chainedPollingStrategy.getResult(context, resultType);
    }

    @Override
    public Mono<Boolean> canPoll(Response<?> initialResponse) {
        return this.chainedPollingStrategy.canPoll(initialResponse);
    }

    @Override
    public Mono<PollResponse<T>> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        return this.chainedPollingStrategy.onInitialResponse(response, pollingContext, pollResponseType);
    }

    @Override
    public Mono<PollResponse<T>> poll(PollingContext<T> context, TypeReference<T> pollResponseType) {
        return this.chainedPollingStrategy.poll(context, pollResponseType);
    }
}

