/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util.polling;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.serializer.DefaultJsonSerializer;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollingContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollingStrategyOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncChainedPollingStrategy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncLocationPollingStrategy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncOperationResourcePollingStrategy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPollingStrategy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncStatusCheckPollingStrategy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.JsonSerializer;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.TypeReference;
import java.util.Arrays;
import java.util.Objects;

public final class SyncDefaultPollingStrategy<T, U>
implements SyncPollingStrategy<T, U> {
    private final SyncChainedPollingStrategy<T, U> chainedPollingStrategy;

    public SyncDefaultPollingStrategy(HttpPipeline httpPipeline) {
        this(httpPipeline, new DefaultJsonSerializer(), Context.NONE);
    }

    public SyncDefaultPollingStrategy(HttpPipeline httpPipeline, JsonSerializer serializer) {
        this(httpPipeline, serializer, Context.NONE);
    }

    public SyncDefaultPollingStrategy(HttpPipeline httpPipeline, JsonSerializer serializer, Context context) {
        this(httpPipeline, null, serializer, context);
    }

    public SyncDefaultPollingStrategy(HttpPipeline httpPipeline, String endpoint, JsonSerializer serializer, Context context) {
        this.chainedPollingStrategy = new SyncChainedPollingStrategy(Arrays.asList(new SyncOperationResourcePollingStrategy(httpPipeline, endpoint, serializer, null, context), new SyncLocationPollingStrategy(httpPipeline, endpoint, serializer, context), new SyncStatusCheckPollingStrategy(serializer)));
    }

    public SyncDefaultPollingStrategy(PollingStrategyOptions pollingStrategyOptions) {
        Objects.requireNonNull(pollingStrategyOptions, "'pollingStrategyOptions' cannot be null");
        this.chainedPollingStrategy = new SyncChainedPollingStrategy(Arrays.asList(new SyncOperationResourcePollingStrategy(null, pollingStrategyOptions), new SyncLocationPollingStrategy(pollingStrategyOptions), new SyncStatusCheckPollingStrategy(pollingStrategyOptions.getSerializer())));
    }

    @Override
    public U getResult(PollingContext<T> pollingContext, TypeReference<U> resultType) {
        return this.chainedPollingStrategy.getResult(pollingContext, resultType);
    }

    @Override
    public boolean canPoll(Response<?> initialResponse) {
        return this.chainedPollingStrategy.canPoll(initialResponse);
    }

    @Override
    public PollResponse<T> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        return this.chainedPollingStrategy.onInitialResponse(response, pollingContext, pollResponseType);
    }

    @Override
    public PollResponse<T> poll(PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        return this.chainedPollingStrategy.poll(pollingContext, pollResponseType);
    }

    @Override
    public T cancel(PollingContext<T> pollingContext, PollResponse<T> initialResponse) {
        return this.chainedPollingStrategy.cancel(pollingContext, initialResponse);
    }
}

