/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.identity;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.identity.CredentialUnavailableException;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClient;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClientOptions;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.LoggingUtil;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public class AzurePowerShellCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(AzurePowerShellCredential.class);
    private final IdentityClient identityClient;

    AzurePowerShellCredential(String tenantId, IdentityClientOptions options) {
        this.identityClient = new IdentityClientBuilder().identityClientOptions(options).tenantId(tenantId).build();
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return this.identityClient.authenticateWithAzurePowerShell(request).doOnNext(token -> LoggingUtil.logTokenSuccess(LOGGER, request)).doOnError(error -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, error)).onErrorMap(error -> {
            if (this.identityClient.getIdentityClientOptions().isChained()) {
                return new CredentialUnavailableException(error.getMessage(), (Throwable)error);
            }
            return error;
        });
    }
}

