/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.identity;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.identity.ClientCertificateCredential;
import com.dataiku.dss.shadelibazure.com.azure.identity.ClientSecretCredential;
import com.dataiku.dss.shadelibazure.com.azure.identity.CredentialUnavailableException;
import com.dataiku.dss.shadelibazure.com.azure.identity.UsernamePasswordCredential;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClientOptions;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.IdentityUtil;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.LoggingUtil;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.ValidationUtil;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public class EnvironmentCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(EnvironmentCredential.class);
    private final TokenCredential tokenCredential;
    private final IdentityClientOptions identityClientOptions;

    EnvironmentCredential(IdentityClientOptions identityClientOptions) {
        Configuration configuration = identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : identityClientOptions.getConfiguration();
        TokenCredential targetCredential = null;
        this.identityClientOptions = identityClientOptions;
        String clientId = configuration.get("AZURE_CLIENT_ID");
        String tenantId = configuration.get("AZURE_TENANT_ID");
        String clientSecret = configuration.get("AZURE_CLIENT_SECRET");
        String certPath = configuration.get("AZURE_CLIENT_CERTIFICATE_PATH");
        String certPassword = configuration.get("AZURE_CLIENT_CERTIFICATE_PASSWORD");
        String username = configuration.get("AZURE_USERNAME");
        String password = configuration.get("AZURE_PASSWORD");
        String sendCertificateChain = configuration.get("AZURE_CLIENT_SEND_CERTIFICATE_CHAIN", "false");
        if (CoreUtils.isNullOrEmpty(identityClientOptions.getAdditionallyAllowedTenants())) {
            identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.getAdditionalTenantsFromEnvironment(configuration));
        }
        ValidationUtil.validateTenantIdCharacterRange(tenantId, LOGGER);
        LoggingUtil.logAvailableEnvironmentVariables(LOGGER, configuration);
        if (this.verifyNotNull(clientId)) {
            if (this.verifyNotNull(tenantId)) {
                if (this.verifyNotNull(clientSecret)) {
                    LOGGER.info("Azure Identity => EnvironmentCredential invoking ClientSecretCredential");
                    targetCredential = new ClientSecretCredential(tenantId, clientId, clientSecret, identityClientOptions);
                } else if (this.verifyNotNull(certPath)) {
                    LOGGER.info("Azure Identity => EnvironmentCredential invoking ClientCertificateCredential");
                    if ("true".equalsIgnoreCase(sendCertificateChain) || "1".equals(sendCertificateChain)) {
                        identityClientOptions.setIncludeX5c(true);
                    }
                    targetCredential = new ClientCertificateCredential(tenantId, clientId, certPath, null, certPassword, identityClientOptions);
                } else {
                    LoggingUtil.logError(LOGGER, identityClientOptions, () -> String.format("Azure Identity => ERROR in EnvironmentCredential: Failed to create a ClientSecretCredential or ClientCertificateCredential. Missing required environment variable either %s or %s", "AZURE_CLIENT_SECRET", "AZURE_CLIENT_CERTIFICATE_PATH"));
                }
            } else if (this.verifyNotNull(clientSecret) || this.verifyNotNull(certPath)) {
                LoggingUtil.logError(LOGGER, identityClientOptions, () -> String.format("Azure Identity => ERROR in EnvironmentCredential: Failed to create a ClientSecretCredential or ClientCertificateCredential. Missing required environment variable %s", "AZURE_TENANT_ID"));
            }
            if (targetCredential == null && this.verifyNotNull(username, password)) {
                LOGGER.info("Azure Identity => EnvironmentCredential invoking UsernamePasswordCredential");
                LOGGER.warning("Environment is configured to use username and password authentication. This authentication method is deprecated, as it doesn't support multifactor authentication (MFA). Use a more secure credential. For more details, see https://aka.ms/azsdk/identity/mfa.");
                targetCredential = new UsernamePasswordCredential(clientId, tenantId, username, password, identityClientOptions);
            } else if (this.verifyNotNull(username) ^ this.verifyNotNull(password)) {
                LoggingUtil.logError(LOGGER, identityClientOptions, () -> String.format("Azure Identity => ERROR in EnvironmentCredential: Failed to create a UsernamePasswordCredential. Missing required environment variable %s", username == null ? "AZURE_USERNAME" : "AZURE_PASSWORD"));
            }
            if (targetCredential == null) {
                String msg = String.format("Azure Identity => ERROR in EnvironmentCredential: Failed to determine an authentication scheme based on the available environment variables. Please specify %1$s and %2$s to authenticate through a ClientSecretCredential; %1$s and %3$s to authenticate through a ClientCertificateCredential.", "AZURE_TENANT_ID", "AZURE_CLIENT_SECRET", "AZURE_CLIENT_CERTIFICATE_PATH");
                LoggingUtil.logError(LOGGER, identityClientOptions, msg);
            }
        } else {
            LoggingUtil.logError(LOGGER, identityClientOptions, () -> String.format("Azure Identity => ERROR in EnvironmentCredential: Missing required environment variable %s", "AZURE_CLIENT_ID"));
        }
        this.tokenCredential = targetCredential;
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext request) {
        if (this.tokenCredential == null) {
            return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClientOptions, new CredentialUnavailableException("EnvironmentCredential authentication unavailable. Environment variables are not fully configured.To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/environmentcredential/troubleshoot")));
        }
        return this.tokenCredential.getToken(request);
    }

    @Override
    public AccessToken getTokenSync(TokenRequestContext request) {
        if (this.tokenCredential == null) {
            throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClientOptions, new CredentialUnavailableException("EnvironmentCredential authentication unavailable. Environment variables are not fully configured.To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/environmentcredential/troubleshoot"));
        }
        return this.tokenCredential.getTokenSync(request);
    }

    private boolean verifyNotNull(String ... configs) {
        for (String config : configs) {
            if (config != null) continue;
            return false;
        }
        return true;
    }
}

