/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.AzureFileVolume;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.Type;
import java.io.IOException;
import java.util.List;

public class CustomPersistentDiskProperties
implements JsonSerializable<CustomPersistentDiskProperties> {
    private Type type = Type.fromString("CustomPersistentDiskProperties");
    private String mountPath;
    private Boolean readOnly;
    private Boolean enableSubPath;
    private List<String> mountOptions;
    private static final ClientLogger LOGGER = new ClientLogger(CustomPersistentDiskProperties.class);

    public Type type() {
        return this.type;
    }

    public String mountPath() {
        return this.mountPath;
    }

    public CustomPersistentDiskProperties withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return this;
    }

    public Boolean readOnly() {
        return this.readOnly;
    }

    public CustomPersistentDiskProperties withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public Boolean enableSubPath() {
        return this.enableSubPath;
    }

    public CustomPersistentDiskProperties withEnableSubPath(Boolean enableSubPath) {
        this.enableSubPath = enableSubPath;
        return this;
    }

    public List<String> mountOptions() {
        return this.mountOptions;
    }

    public CustomPersistentDiskProperties withMountOptions(List<String> mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    public void validate() {
        if (this.mountPath() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property mountPath in model CustomPersistentDiskProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mountPath", this.mountPath);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeBooleanField("readOnly", this.readOnly);
        jsonWriter.writeBooleanField("enableSubPath", this.enableSubPath);
        jsonWriter.writeArrayField("mountOptions", this.mountOptions, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static CustomPersistentDiskProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                CustomPersistentDiskProperties customPersistentDiskProperties;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("AzureFileVolume".equals(discriminatorValue)) {
                    customPersistentDiskProperties = AzureFileVolume.fromJson(readerToUse.reset());
                    return customPersistentDiskProperties;
                }
                customPersistentDiskProperties = CustomPersistentDiskProperties.fromJsonKnownDiscriminator(readerToUse.reset());
                return customPersistentDiskProperties;
            }
        });
    }

    static CustomPersistentDiskProperties fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomPersistentDiskProperties deserializedCustomPersistentDiskProperties = new CustomPersistentDiskProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("mountPath".equals(fieldName)) {
                    deserializedCustomPersistentDiskProperties.mountPath = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCustomPersistentDiskProperties.type = Type.fromString(reader.getString());
                    continue;
                }
                if ("readOnly".equals(fieldName)) {
                    deserializedCustomPersistentDiskProperties.readOnly = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableSubPath".equals(fieldName)) {
                    deserializedCustomPersistentDiskProperties.enableSubPath = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("mountOptions".equals(fieldName)) {
                    List<String> mountOptions = reader.readArray(reader1 -> reader1.getString());
                    deserializedCustomPersistentDiskProperties.mountOptions = mountOptions;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomPersistentDiskProperties;
        });
    }
}

