/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.AppServiceCertificateInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.CertificateDetails;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.CertificateOrderContact;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.CertificateOrderStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.CertificateProductType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ResourceNotRenewableReason;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class AppServiceCertificateOrderProperties
implements JsonSerializable<AppServiceCertificateOrderProperties> {
    private Map<String, AppServiceCertificateInner> certificates;
    private String distinguishedName;
    private String domainVerificationToken;
    private Integer validityInYears;
    private Integer keySize;
    private CertificateProductType productType;
    private Boolean autoRenew;
    private ProvisioningState provisioningState;
    private CertificateOrderStatus status;
    private CertificateDetails signedCertificate;
    private String csr;
    private CertificateDetails intermediate;
    private CertificateDetails root;
    private String serialNumber;
    private OffsetDateTime lastCertificateIssuanceTime;
    private OffsetDateTime expirationTime;
    private Boolean isPrivateKeyExternal;
    private List<ResourceNotRenewableReason> appServiceCertificateNotRenewableReasons;
    private OffsetDateTime nextAutoRenewalTimestamp;
    private CertificateOrderContact contact;
    private static final ClientLogger LOGGER = new ClientLogger(AppServiceCertificateOrderProperties.class);

    public Map<String, AppServiceCertificateInner> certificates() {
        return this.certificates;
    }

    public AppServiceCertificateOrderProperties withCertificates(Map<String, AppServiceCertificateInner> certificates) {
        this.certificates = certificates;
        return this;
    }

    public String distinguishedName() {
        return this.distinguishedName;
    }

    public AppServiceCertificateOrderProperties withDistinguishedName(String distinguishedName) {
        this.distinguishedName = distinguishedName;
        return this;
    }

    public String domainVerificationToken() {
        return this.domainVerificationToken;
    }

    public Integer validityInYears() {
        return this.validityInYears;
    }

    public AppServiceCertificateOrderProperties withValidityInYears(Integer validityInYears) {
        this.validityInYears = validityInYears;
        return this;
    }

    public Integer keySize() {
        return this.keySize;
    }

    public AppServiceCertificateOrderProperties withKeySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    public CertificateProductType productType() {
        return this.productType;
    }

    public AppServiceCertificateOrderProperties withProductType(CertificateProductType productType) {
        this.productType = productType;
        return this;
    }

    public Boolean autoRenew() {
        return this.autoRenew;
    }

    public AppServiceCertificateOrderProperties withAutoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public CertificateOrderStatus status() {
        return this.status;
    }

    public CertificateDetails signedCertificate() {
        return this.signedCertificate;
    }

    public String csr() {
        return this.csr;
    }

    public AppServiceCertificateOrderProperties withCsr(String csr) {
        this.csr = csr;
        return this;
    }

    public CertificateDetails intermediate() {
        return this.intermediate;
    }

    public CertificateDetails root() {
        return this.root;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public OffsetDateTime lastCertificateIssuanceTime() {
        return this.lastCertificateIssuanceTime;
    }

    public OffsetDateTime expirationTime() {
        return this.expirationTime;
    }

    public Boolean isPrivateKeyExternal() {
        return this.isPrivateKeyExternal;
    }

    public List<ResourceNotRenewableReason> appServiceCertificateNotRenewableReasons() {
        return this.appServiceCertificateNotRenewableReasons;
    }

    public OffsetDateTime nextAutoRenewalTimestamp() {
        return this.nextAutoRenewalTimestamp;
    }

    public CertificateOrderContact contact() {
        return this.contact;
    }

    public void validate() {
        if (this.certificates() != null) {
            this.certificates().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.productType() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property productType in model AppServiceCertificateOrderProperties"));
        }
        if (this.signedCertificate() != null) {
            this.signedCertificate().validate();
        }
        if (this.intermediate() != null) {
            this.intermediate().validate();
        }
        if (this.root() != null) {
            this.root().validate();
        }
        if (this.contact() != null) {
            this.contact().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("productType", this.productType == null ? null : this.productType.toString());
        jsonWriter.writeMapField("certificates", this.certificates, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("distinguishedName", this.distinguishedName);
        jsonWriter.writeNumberField("validityInYears", this.validityInYears);
        jsonWriter.writeNumberField("keySize", this.keySize);
        jsonWriter.writeBooleanField("autoRenew", this.autoRenew);
        jsonWriter.writeStringField("csr", this.csr);
        return jsonWriter.writeEndObject();
    }

    public static AppServiceCertificateOrderProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AppServiceCertificateOrderProperties deserializedAppServiceCertificateOrderProperties = new AppServiceCertificateOrderProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("productType".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderProperties.productType = CertificateProductType.fromString(reader.getString());
                    continue;
                }
                if ("certificates".equals(fieldName)) {
                    Map<String, AppServiceCertificateInner> certificates = reader.readMap(reader1 -> AppServiceCertificateInner.fromJson(reader1));
                    deserializedAppServiceCertificateOrderProperties.certificates = certificates;
                    continue;
                }
                if ("distinguishedName".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderProperties.distinguishedName = reader.getString();
                    continue;
                }
                if ("domainVerificationToken".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderProperties.domainVerificationToken = reader.getString();
                    continue;
                }
                if ("validityInYears".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderProperties.validityInYears = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("keySize".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderProperties.keySize = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("autoRenew".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderProperties.autoRenew = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderProperties.status = CertificateOrderStatus.fromString(reader.getString());
                    continue;
                }
                if ("signedCertificate".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderProperties.signedCertificate = CertificateDetails.fromJson(reader);
                    continue;
                }
                if ("csr".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderProperties.csr = reader.getString();
                    continue;
                }
                if ("intermediate".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderProperties.intermediate = CertificateDetails.fromJson(reader);
                    continue;
                }
                if ("root".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderProperties.root = CertificateDetails.fromJson(reader);
                    continue;
                }
                if ("serialNumber".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderProperties.serialNumber = reader.getString();
                    continue;
                }
                if ("lastCertificateIssuanceTime".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderProperties.lastCertificateIssuanceTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("expirationTime".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderProperties.expirationTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("isPrivateKeyExternal".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderProperties.isPrivateKeyExternal = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("appServiceCertificateNotRenewableReasons".equals(fieldName)) {
                    List<ResourceNotRenewableReason> appServiceCertificateNotRenewableReasons = reader.readArray(reader1 -> ResourceNotRenewableReason.fromString(reader1.getString()));
                    deserializedAppServiceCertificateOrderProperties.appServiceCertificateNotRenewableReasons = appServiceCertificateNotRenewableReasons;
                    continue;
                }
                if ("nextAutoRenewalTimeStamp".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderProperties.nextAutoRenewalTimestamp = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("contact".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderProperties.contact = CertificateOrderContact.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAppServiceCertificateOrderProperties;
        });
    }
}

