/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Contact;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DnsType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DomainPurchaseConsent;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DomainStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Hostname;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ResourceNotRenewableReason;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class DomainProperties
implements JsonSerializable<DomainProperties> {
    private Contact contactAdmin;
    private Contact contactBilling;
    private Contact contactRegistrant;
    private Contact contactTech;
    private DomainStatus registrationStatus;
    private ProvisioningState provisioningState;
    private List<String> nameServers;
    private Boolean privacy;
    private OffsetDateTime createdTime;
    private OffsetDateTime expirationTime;
    private OffsetDateTime lastRenewedTime;
    private Boolean autoRenew;
    private Boolean readyForDnsRecordManagement;
    private List<Hostname> managedHostNames;
    private DomainPurchaseConsent consent;
    private List<ResourceNotRenewableReason> domainNotRenewableReasons;
    private DnsType dnsType;
    private String dnsZoneId;
    private DnsType targetDnsType;
    private String authCode;
    private static final ClientLogger LOGGER = new ClientLogger(DomainProperties.class);

    public Contact contactAdmin() {
        return this.contactAdmin;
    }

    public DomainProperties withContactAdmin(Contact contactAdmin) {
        this.contactAdmin = contactAdmin;
        return this;
    }

    public Contact contactBilling() {
        return this.contactBilling;
    }

    public DomainProperties withContactBilling(Contact contactBilling) {
        this.contactBilling = contactBilling;
        return this;
    }

    public Contact contactRegistrant() {
        return this.contactRegistrant;
    }

    public DomainProperties withContactRegistrant(Contact contactRegistrant) {
        this.contactRegistrant = contactRegistrant;
        return this;
    }

    public Contact contactTech() {
        return this.contactTech;
    }

    public DomainProperties withContactTech(Contact contactTech) {
        this.contactTech = contactTech;
        return this;
    }

    public DomainStatus registrationStatus() {
        return this.registrationStatus;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<String> nameServers() {
        return this.nameServers;
    }

    public Boolean privacy() {
        return this.privacy;
    }

    public DomainProperties withPrivacy(Boolean privacy) {
        this.privacy = privacy;
        return this;
    }

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public OffsetDateTime expirationTime() {
        return this.expirationTime;
    }

    public OffsetDateTime lastRenewedTime() {
        return this.lastRenewedTime;
    }

    public Boolean autoRenew() {
        return this.autoRenew;
    }

    public DomainProperties withAutoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
        return this;
    }

    public Boolean readyForDnsRecordManagement() {
        return this.readyForDnsRecordManagement;
    }

    public List<Hostname> managedHostNames() {
        return this.managedHostNames;
    }

    public DomainPurchaseConsent consent() {
        return this.consent;
    }

    public DomainProperties withConsent(DomainPurchaseConsent consent) {
        this.consent = consent;
        return this;
    }

    public List<ResourceNotRenewableReason> domainNotRenewableReasons() {
        return this.domainNotRenewableReasons;
    }

    public DnsType dnsType() {
        return this.dnsType;
    }

    public DomainProperties withDnsType(DnsType dnsType) {
        this.dnsType = dnsType;
        return this;
    }

    public String dnsZoneId() {
        return this.dnsZoneId;
    }

    public DomainProperties withDnsZoneId(String dnsZoneId) {
        this.dnsZoneId = dnsZoneId;
        return this;
    }

    public DnsType targetDnsType() {
        return this.targetDnsType;
    }

    public DomainProperties withTargetDnsType(DnsType targetDnsType) {
        this.targetDnsType = targetDnsType;
        return this;
    }

    public String authCode() {
        return this.authCode;
    }

    public DomainProperties withAuthCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    public void validate() {
        if (this.contactAdmin() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property contactAdmin in model DomainProperties"));
        }
        this.contactAdmin().validate();
        if (this.contactBilling() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property contactBilling in model DomainProperties"));
        }
        this.contactBilling().validate();
        if (this.contactRegistrant() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property contactRegistrant in model DomainProperties"));
        }
        this.contactRegistrant().validate();
        if (this.contactTech() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property contactTech in model DomainProperties"));
        }
        this.contactTech().validate();
        if (this.managedHostNames() != null) {
            this.managedHostNames().forEach(e -> e.validate());
        }
        if (this.consent() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property consent in model DomainProperties"));
        }
        this.consent().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("contactAdmin", this.contactAdmin);
        jsonWriter.writeJsonField("contactBilling", this.contactBilling);
        jsonWriter.writeJsonField("contactRegistrant", this.contactRegistrant);
        jsonWriter.writeJsonField("contactTech", this.contactTech);
        jsonWriter.writeJsonField("consent", this.consent);
        jsonWriter.writeBooleanField("privacy", this.privacy);
        jsonWriter.writeBooleanField("autoRenew", this.autoRenew);
        jsonWriter.writeStringField("dnsType", this.dnsType == null ? null : this.dnsType.toString());
        jsonWriter.writeStringField("dnsZoneId", this.dnsZoneId);
        jsonWriter.writeStringField("targetDnsType", this.targetDnsType == null ? null : this.targetDnsType.toString());
        jsonWriter.writeStringField("authCode", this.authCode);
        return jsonWriter.writeEndObject();
    }

    public static DomainProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DomainProperties deserializedDomainProperties = new DomainProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contactAdmin".equals(fieldName)) {
                    deserializedDomainProperties.contactAdmin = Contact.fromJson(reader);
                    continue;
                }
                if ("contactBilling".equals(fieldName)) {
                    deserializedDomainProperties.contactBilling = Contact.fromJson(reader);
                    continue;
                }
                if ("contactRegistrant".equals(fieldName)) {
                    deserializedDomainProperties.contactRegistrant = Contact.fromJson(reader);
                    continue;
                }
                if ("contactTech".equals(fieldName)) {
                    deserializedDomainProperties.contactTech = Contact.fromJson(reader);
                    continue;
                }
                if ("consent".equals(fieldName)) {
                    deserializedDomainProperties.consent = DomainPurchaseConsent.fromJson(reader);
                    continue;
                }
                if ("registrationStatus".equals(fieldName)) {
                    deserializedDomainProperties.registrationStatus = DomainStatus.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDomainProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("nameServers".equals(fieldName)) {
                    List<String> nameServers = reader.readArray(reader1 -> reader1.getString());
                    deserializedDomainProperties.nameServers = nameServers;
                    continue;
                }
                if ("privacy".equals(fieldName)) {
                    deserializedDomainProperties.privacy = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("createdTime".equals(fieldName)) {
                    deserializedDomainProperties.createdTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("expirationTime".equals(fieldName)) {
                    deserializedDomainProperties.expirationTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("lastRenewedTime".equals(fieldName)) {
                    deserializedDomainProperties.lastRenewedTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("autoRenew".equals(fieldName)) {
                    deserializedDomainProperties.autoRenew = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("readyForDnsRecordManagement".equals(fieldName)) {
                    deserializedDomainProperties.readyForDnsRecordManagement = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("managedHostNames".equals(fieldName)) {
                    List<Hostname> managedHostNames = reader.readArray(reader1 -> Hostname.fromJson(reader1));
                    deserializedDomainProperties.managedHostNames = managedHostNames;
                    continue;
                }
                if ("domainNotRenewableReasons".equals(fieldName)) {
                    List<ResourceNotRenewableReason> domainNotRenewableReasons = reader.readArray(reader1 -> ResourceNotRenewableReason.fromString(reader1.getString()));
                    deserializedDomainProperties.domainNotRenewableReasons = domainNotRenewableReasons;
                    continue;
                }
                if ("dnsType".equals(fieldName)) {
                    deserializedDomainProperties.dnsType = DnsType.fromString(reader.getString());
                    continue;
                }
                if ("dnsZoneId".equals(fieldName)) {
                    deserializedDomainProperties.dnsZoneId = reader.getString();
                    continue;
                }
                if ("targetDnsType".equals(fieldName)) {
                    deserializedDomainProperties.targetDnsType = DnsType.fromString(reader.getString());
                    continue;
                }
                if ("authCode".equals(fieldName)) {
                    deserializedDomainProperties.authCode = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDomainProperties;
        });
    }
}

