/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ErrorEntity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.OperationStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class OperationInner
implements JsonSerializable<OperationInner> {
    private String id;
    private String name;
    private OperationStatus status;
    private List<ErrorEntity> errors;
    private OffsetDateTime createdTime;
    private OffsetDateTime modifiedTime;
    private OffsetDateTime expirationTime;
    private UUID geoMasterOperationId;

    public String id() {
        return this.id;
    }

    public OperationInner withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public OperationInner withName(String name) {
        this.name = name;
        return this;
    }

    public OperationStatus status() {
        return this.status;
    }

    public OperationInner withStatus(OperationStatus status) {
        this.status = status;
        return this;
    }

    public List<ErrorEntity> errors() {
        return this.errors;
    }

    public OperationInner withErrors(List<ErrorEntity> errors) {
        this.errors = errors;
        return this;
    }

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public OperationInner withCreatedTime(OffsetDateTime createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public OffsetDateTime modifiedTime() {
        return this.modifiedTime;
    }

    public OperationInner withModifiedTime(OffsetDateTime modifiedTime) {
        this.modifiedTime = modifiedTime;
        return this;
    }

    public OffsetDateTime expirationTime() {
        return this.expirationTime;
    }

    public OperationInner withExpirationTime(OffsetDateTime expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    public UUID geoMasterOperationId() {
        return this.geoMasterOperationId;
    }

    public OperationInner withGeoMasterOperationId(UUID geoMasterOperationId) {
        this.geoMasterOperationId = geoMasterOperationId;
        return this;
    }

    public void validate() {
        if (this.errors() != null) {
            this.errors().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("createdTime", this.createdTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdTime));
        jsonWriter.writeStringField("modifiedTime", this.modifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.modifiedTime));
        jsonWriter.writeStringField("expirationTime", this.expirationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationTime));
        jsonWriter.writeStringField("geoMasterOperationId", Objects.toString(this.geoMasterOperationId, null));
        return jsonWriter.writeEndObject();
    }

    public static OperationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationInner deserializedOperationInner = new OperationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedOperationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedOperationInner.name = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedOperationInner.status = OperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List<ErrorEntity> errors = reader.readArray(reader1 -> ErrorEntity.fromJson(reader1));
                    deserializedOperationInner.errors = errors;
                    continue;
                }
                if ("createdTime".equals(fieldName)) {
                    deserializedOperationInner.createdTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("modifiedTime".equals(fieldName)) {
                    deserializedOperationInner.modifiedTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("expirationTime".equals(fieldName)) {
                    deserializedOperationInner.expirationTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("geoMasterOperationId".equals(fieldName)) {
                    deserializedOperationInner.geoMasterOperationId = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationInner;
        });
    }
}

