/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.PrivateAccessVirtualNetwork;
import java.io.IOException;
import java.util.List;

public final class PrivateAccessProperties
implements JsonSerializable<PrivateAccessProperties> {
    private Boolean enabled;
    private List<PrivateAccessVirtualNetwork> virtualNetworks;

    public Boolean enabled() {
        return this.enabled;
    }

    public PrivateAccessProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<PrivateAccessVirtualNetwork> virtualNetworks() {
        return this.virtualNetworks;
    }

    public PrivateAccessProperties withVirtualNetworks(List<PrivateAccessVirtualNetwork> virtualNetworks) {
        this.virtualNetworks = virtualNetworks;
        return this;
    }

    public void validate() {
        if (this.virtualNetworks() != null) {
            this.virtualNetworks().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeArrayField("virtualNetworks", this.virtualNetworks, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static PrivateAccessProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateAccessProperties deserializedPrivateAccessProperties = new PrivateAccessProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedPrivateAccessProperties.enabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("virtualNetworks".equals(fieldName)) {
                    List<PrivateAccessVirtualNetwork> virtualNetworks = reader.readArray(reader1 -> PrivateAccessVirtualNetwork.fromJson(reader1));
                    deserializedPrivateAccessProperties.virtualNetworks = virtualNetworks;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateAccessProperties;
        });
    }
}

