/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.CertificateOrdersDiagnosticsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.DetectorResponseInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.WebSiteManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DetectorResponseCollection;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.OffsetDateTime;

public final class CertificateOrdersDiagnosticsClientImpl
implements CertificateOrdersDiagnosticsClient {
    private final CertificateOrdersDiagnosticsService service;
    private final WebSiteManagementClientImpl client;

    CertificateOrdersDiagnosticsClientImpl(WebSiteManagementClientImpl client) {
        this.service = RestProxy.create(CertificateOrdersDiagnosticsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorResponseInner>> listAppServiceCertificateOrderDetectorResponseSinglePageAsync(String resourceGroupName, String certificateOrderName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error(new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAppServiceCertificateOrderDetectorResponse(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DetectorResponseInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DetectorResponseCollection)res.getValue()).value(), ((DetectorResponseCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorResponseInner>> listAppServiceCertificateOrderDetectorResponseSinglePageAsync(String resourceGroupName, String certificateOrderName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error(new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAppServiceCertificateOrderDetectorResponse(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, DetectorResponseInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DetectorResponseCollection)res.getValue()).value(), ((DetectorResponseCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DetectorResponseInner> listAppServiceCertificateOrderDetectorResponseAsync(String resourceGroupName, String certificateOrderName) {
        return new PagedFlux<DetectorResponseInner>(() -> this.listAppServiceCertificateOrderDetectorResponseSinglePageAsync(resourceGroupName, certificateOrderName), nextLink -> this.listAppServiceCertificateOrderDetectorResponseNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DetectorResponseInner> listAppServiceCertificateOrderDetectorResponseAsync(String resourceGroupName, String certificateOrderName, Context context) {
        return new PagedFlux<DetectorResponseInner>(() -> this.listAppServiceCertificateOrderDetectorResponseSinglePageAsync(resourceGroupName, certificateOrderName, context), nextLink -> this.listAppServiceCertificateOrderDetectorResponseNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DetectorResponseInner> listAppServiceCertificateOrderDetectorResponse(String resourceGroupName, String certificateOrderName) {
        return new PagedIterable<DetectorResponseInner>(this.listAppServiceCertificateOrderDetectorResponseAsync(resourceGroupName, certificateOrderName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DetectorResponseInner> listAppServiceCertificateOrderDetectorResponse(String resourceGroupName, String certificateOrderName, Context context) {
        return new PagedIterable<DetectorResponseInner>(this.listAppServiceCertificateOrderDetectorResponseAsync(resourceGroupName, certificateOrderName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DetectorResponseInner>> getAppServiceCertificateOrderDetectorResponseWithResponseAsync(String resourceGroupName, String certificateOrderName, String detectorName, OffsetDateTime startTime, OffsetDateTime endTime, String timeGrain) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error(new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAppServiceCertificateOrderDetectorResponse(this.client.getEndpoint(), resourceGroupName, certificateOrderName, detectorName, startTime, endTime, timeGrain, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DetectorResponseInner>> getAppServiceCertificateOrderDetectorResponseWithResponseAsync(String resourceGroupName, String certificateOrderName, String detectorName, OffsetDateTime startTime, OffsetDateTime endTime, String timeGrain, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error(new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAppServiceCertificateOrderDetectorResponse(this.client.getEndpoint(), resourceGroupName, certificateOrderName, detectorName, startTime, endTime, timeGrain, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DetectorResponseInner> getAppServiceCertificateOrderDetectorResponseAsync(String resourceGroupName, String certificateOrderName, String detectorName) {
        OffsetDateTime startTime = null;
        OffsetDateTime endTime = null;
        String timeGrain = null;
        return this.getAppServiceCertificateOrderDetectorResponseWithResponseAsync(resourceGroupName, certificateOrderName, detectorName, startTime, endTime, timeGrain).flatMap(res -> Mono.justOrEmpty((DetectorResponseInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DetectorResponseInner> getAppServiceCertificateOrderDetectorResponseWithResponse(String resourceGroupName, String certificateOrderName, String detectorName, OffsetDateTime startTime, OffsetDateTime endTime, String timeGrain, Context context) {
        return this.getAppServiceCertificateOrderDetectorResponseWithResponseAsync(resourceGroupName, certificateOrderName, detectorName, startTime, endTime, timeGrain, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DetectorResponseInner getAppServiceCertificateOrderDetectorResponse(String resourceGroupName, String certificateOrderName, String detectorName) {
        OffsetDateTime startTime = null;
        OffsetDateTime endTime = null;
        String timeGrain = null;
        return this.getAppServiceCertificateOrderDetectorResponseWithResponse(resourceGroupName, certificateOrderName, detectorName, startTime, endTime, timeGrain, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorResponseInner>> listAppServiceCertificateOrderDetectorResponseNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAppServiceCertificateOrderDetectorResponseNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DetectorResponseInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DetectorResponseCollection)res.getValue()).value(), ((DetectorResponseCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorResponseInner>> listAppServiceCertificateOrderDetectorResponseNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAppServiceCertificateOrderDetectorResponseNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, DetectorResponseInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DetectorResponseCollection)res.getValue()).value(), ((DetectorResponseCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="WebSiteManagementCli")
    public static interface CertificateOrdersDiagnosticsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/detectors")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<DetectorResponseCollection>> listAppServiceCertificateOrderDetectorResponse(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="certificateOrderName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/detectors/{detectorName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<DetectorResponseInner>> getAppServiceCertificateOrderDetectorResponse(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="certificateOrderName") String var3, @PathParam(value="detectorName") String var4, @QueryParam(value="startTime") OffsetDateTime var5, @QueryParam(value="endTime") OffsetDateTime var6, @QueryParam(value="timeGrain") String var7, @PathParam(value="subscriptionId") String var8, @QueryParam(value="api-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<DetectorResponseCollection>> listAppServiceCertificateOrderDetectorResponseNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

