/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.ProvidersClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.ApplicationStackResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.CsmOperationDescriptionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.FunctionAppStackInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.WebAppStackInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.WebSiteManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ApplicationStackCollection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.CsmOperationCollection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.FunctionAppStackCollection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ProviderOsTypeSelected;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ProviderStackOsType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WebAppStackCollection;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class ProvidersClientImpl
implements ProvidersClient {
    private final ProvidersService service;
    private final WebSiteManagementClientImpl client;

    ProvidersClientImpl(WebSiteManagementClientImpl client) {
        this.service = RestProxy.create(ProvidersService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationStackResourceInner>> getAvailableStacksSinglePageAsync(ProviderOsTypeSelected osTypeSelected) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAvailableStacks(this.client.getEndpoint(), osTypeSelected, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ApplicationStackResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationStackCollection)res.getValue()).value(), ((ApplicationStackCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationStackResourceInner>> getAvailableStacksSinglePageAsync(ProviderOsTypeSelected osTypeSelected, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAvailableStacks(this.client.getEndpoint(), osTypeSelected, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, ApplicationStackResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationStackCollection)res.getValue()).value(), ((ApplicationStackCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ApplicationStackResourceInner> getAvailableStacksAsync(ProviderOsTypeSelected osTypeSelected) {
        return new PagedFlux<ApplicationStackResourceInner>(() -> this.getAvailableStacksSinglePageAsync(osTypeSelected), nextLink -> this.getAvailableStacksNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ApplicationStackResourceInner> getAvailableStacksAsync() {
        ProviderOsTypeSelected osTypeSelected = null;
        return new PagedFlux<ApplicationStackResourceInner>(() -> this.getAvailableStacksSinglePageAsync(osTypeSelected), nextLink -> this.getAvailableStacksNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ApplicationStackResourceInner> getAvailableStacksAsync(ProviderOsTypeSelected osTypeSelected, Context context) {
        return new PagedFlux<ApplicationStackResourceInner>(() -> this.getAvailableStacksSinglePageAsync(osTypeSelected, context), nextLink -> this.getAvailableStacksNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApplicationStackResourceInner> getAvailableStacks() {
        ProviderOsTypeSelected osTypeSelected = null;
        return new PagedIterable<ApplicationStackResourceInner>(this.getAvailableStacksAsync(osTypeSelected));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApplicationStackResourceInner> getAvailableStacks(ProviderOsTypeSelected osTypeSelected, Context context) {
        return new PagedIterable<ApplicationStackResourceInner>(this.getAvailableStacksAsync(osTypeSelected, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FunctionAppStackInner>> getFunctionAppStacksSinglePageAsync(ProviderStackOsType stackOsType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getFunctionAppStacks(this.client.getEndpoint(), stackOsType, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, FunctionAppStackInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FunctionAppStackCollection)res.getValue()).value(), ((FunctionAppStackCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FunctionAppStackInner>> getFunctionAppStacksSinglePageAsync(ProviderStackOsType stackOsType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getFunctionAppStacks(this.client.getEndpoint(), stackOsType, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, FunctionAppStackInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FunctionAppStackCollection)res.getValue()).value(), ((FunctionAppStackCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FunctionAppStackInner> getFunctionAppStacksAsync(ProviderStackOsType stackOsType) {
        return new PagedFlux<FunctionAppStackInner>(() -> this.getFunctionAppStacksSinglePageAsync(stackOsType), nextLink -> this.getFunctionAppStacksNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FunctionAppStackInner> getFunctionAppStacksAsync() {
        ProviderStackOsType stackOsType = null;
        return new PagedFlux<FunctionAppStackInner>(() -> this.getFunctionAppStacksSinglePageAsync(stackOsType), nextLink -> this.getFunctionAppStacksNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<FunctionAppStackInner> getFunctionAppStacksAsync(ProviderStackOsType stackOsType, Context context) {
        return new PagedFlux<FunctionAppStackInner>(() -> this.getFunctionAppStacksSinglePageAsync(stackOsType, context), nextLink -> this.getFunctionAppStacksNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FunctionAppStackInner> getFunctionAppStacks() {
        ProviderStackOsType stackOsType = null;
        return new PagedIterable<FunctionAppStackInner>(this.getFunctionAppStacksAsync(stackOsType));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FunctionAppStackInner> getFunctionAppStacks(ProviderStackOsType stackOsType, Context context) {
        return new PagedIterable<FunctionAppStackInner>(this.getFunctionAppStacksAsync(stackOsType, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FunctionAppStackInner>> getFunctionAppStacksForLocationSinglePageAsync(String location, ProviderStackOsType stackOsType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getFunctionAppStacksForLocation(this.client.getEndpoint(), location, stackOsType, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, FunctionAppStackInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FunctionAppStackCollection)res.getValue()).value(), ((FunctionAppStackCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FunctionAppStackInner>> getFunctionAppStacksForLocationSinglePageAsync(String location, ProviderStackOsType stackOsType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getFunctionAppStacksForLocation(this.client.getEndpoint(), location, stackOsType, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, FunctionAppStackInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FunctionAppStackCollection)res.getValue()).value(), ((FunctionAppStackCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FunctionAppStackInner> getFunctionAppStacksForLocationAsync(String location, ProviderStackOsType stackOsType) {
        return new PagedFlux<FunctionAppStackInner>(() -> this.getFunctionAppStacksForLocationSinglePageAsync(location, stackOsType), nextLink -> this.getFunctionAppStacksForLocationNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FunctionAppStackInner> getFunctionAppStacksForLocationAsync(String location) {
        ProviderStackOsType stackOsType = null;
        return new PagedFlux<FunctionAppStackInner>(() -> this.getFunctionAppStacksForLocationSinglePageAsync(location, stackOsType), nextLink -> this.getFunctionAppStacksForLocationNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<FunctionAppStackInner> getFunctionAppStacksForLocationAsync(String location, ProviderStackOsType stackOsType, Context context) {
        return new PagedFlux<FunctionAppStackInner>(() -> this.getFunctionAppStacksForLocationSinglePageAsync(location, stackOsType, context), nextLink -> this.getFunctionAppStacksForLocationNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FunctionAppStackInner> getFunctionAppStacksForLocation(String location) {
        ProviderStackOsType stackOsType = null;
        return new PagedIterable<FunctionAppStackInner>(this.getFunctionAppStacksForLocationAsync(location, stackOsType));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FunctionAppStackInner> getFunctionAppStacksForLocation(String location, ProviderStackOsType stackOsType, Context context) {
        return new PagedIterable<FunctionAppStackInner>(this.getFunctionAppStacksForLocationAsync(location, stackOsType, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WebAppStackInner>> getWebAppStacksForLocationSinglePageAsync(String location, ProviderStackOsType stackOsType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getWebAppStacksForLocation(this.client.getEndpoint(), location, stackOsType, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, WebAppStackInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebAppStackCollection)res.getValue()).value(), ((WebAppStackCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WebAppStackInner>> getWebAppStacksForLocationSinglePageAsync(String location, ProviderStackOsType stackOsType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getWebAppStacksForLocation(this.client.getEndpoint(), location, stackOsType, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, WebAppStackInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebAppStackCollection)res.getValue()).value(), ((WebAppStackCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<WebAppStackInner> getWebAppStacksForLocationAsync(String location, ProviderStackOsType stackOsType) {
        return new PagedFlux<WebAppStackInner>(() -> this.getWebAppStacksForLocationSinglePageAsync(location, stackOsType), nextLink -> this.getWebAppStacksForLocationNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<WebAppStackInner> getWebAppStacksForLocationAsync(String location) {
        ProviderStackOsType stackOsType = null;
        return new PagedFlux<WebAppStackInner>(() -> this.getWebAppStacksForLocationSinglePageAsync(location, stackOsType), nextLink -> this.getWebAppStacksForLocationNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<WebAppStackInner> getWebAppStacksForLocationAsync(String location, ProviderStackOsType stackOsType, Context context) {
        return new PagedFlux<WebAppStackInner>(() -> this.getWebAppStacksForLocationSinglePageAsync(location, stackOsType, context), nextLink -> this.getWebAppStacksForLocationNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WebAppStackInner> getWebAppStacksForLocation(String location) {
        ProviderStackOsType stackOsType = null;
        return new PagedIterable<WebAppStackInner>(this.getWebAppStacksForLocationAsync(location, stackOsType));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WebAppStackInner> getWebAppStacksForLocation(String location, ProviderStackOsType stackOsType, Context context) {
        return new PagedIterable<WebAppStackInner>(this.getWebAppStacksForLocationAsync(location, stackOsType, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CsmOperationDescriptionInner>> listOperationsSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOperations(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, CsmOperationDescriptionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CsmOperationCollection)res.getValue()).value(), ((CsmOperationCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CsmOperationDescriptionInner>> listOperationsSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listOperations(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, CsmOperationDescriptionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CsmOperationCollection)res.getValue()).value(), ((CsmOperationCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CsmOperationDescriptionInner> listOperationsAsync() {
        return new PagedFlux<CsmOperationDescriptionInner>(() -> this.listOperationsSinglePageAsync(), nextLink -> this.listOperationsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CsmOperationDescriptionInner> listOperationsAsync(Context context) {
        return new PagedFlux<CsmOperationDescriptionInner>(() -> this.listOperationsSinglePageAsync(context), nextLink -> this.listOperationsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CsmOperationDescriptionInner> listOperations() {
        return new PagedIterable<CsmOperationDescriptionInner>(this.listOperationsAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CsmOperationDescriptionInner> listOperations(Context context) {
        return new PagedIterable<CsmOperationDescriptionInner>(this.listOperationsAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WebAppStackInner>> getWebAppStacksSinglePageAsync(ProviderStackOsType stackOsType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getWebAppStacks(this.client.getEndpoint(), stackOsType, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, WebAppStackInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebAppStackCollection)res.getValue()).value(), ((WebAppStackCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WebAppStackInner>> getWebAppStacksSinglePageAsync(ProviderStackOsType stackOsType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getWebAppStacks(this.client.getEndpoint(), stackOsType, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, WebAppStackInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebAppStackCollection)res.getValue()).value(), ((WebAppStackCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<WebAppStackInner> getWebAppStacksAsync(ProviderStackOsType stackOsType) {
        return new PagedFlux<WebAppStackInner>(() -> this.getWebAppStacksSinglePageAsync(stackOsType), nextLink -> this.getWebAppStacksNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<WebAppStackInner> getWebAppStacksAsync() {
        ProviderStackOsType stackOsType = null;
        return new PagedFlux<WebAppStackInner>(() -> this.getWebAppStacksSinglePageAsync(stackOsType), nextLink -> this.getWebAppStacksNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<WebAppStackInner> getWebAppStacksAsync(ProviderStackOsType stackOsType, Context context) {
        return new PagedFlux<WebAppStackInner>(() -> this.getWebAppStacksSinglePageAsync(stackOsType, context), nextLink -> this.getWebAppStacksNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WebAppStackInner> getWebAppStacks() {
        ProviderStackOsType stackOsType = null;
        return new PagedIterable<WebAppStackInner>(this.getWebAppStacksAsync(stackOsType));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WebAppStackInner> getWebAppStacks(ProviderStackOsType stackOsType, Context context) {
        return new PagedIterable<WebAppStackInner>(this.getWebAppStacksAsync(stackOsType, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationStackResourceInner>> listSinglePageAsync(ProviderOsTypeSelected osTypeSelected) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), osTypeSelected, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ApplicationStackResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationStackCollection)res.getValue()).value(), ((ApplicationStackCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationStackResourceInner>> listSinglePageAsync(ProviderOsTypeSelected osTypeSelected, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), osTypeSelected, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, ApplicationStackResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationStackCollection)res.getValue()).value(), ((ApplicationStackCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ApplicationStackResourceInner> listAsync(ProviderOsTypeSelected osTypeSelected) {
        return new PagedFlux<ApplicationStackResourceInner>(() -> this.listSinglePageAsync(osTypeSelected), nextLink -> this.getAvailableStacksOnPremNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ApplicationStackResourceInner> listAsync() {
        ProviderOsTypeSelected osTypeSelected = null;
        return new PagedFlux<ApplicationStackResourceInner>(() -> this.listSinglePageAsync(osTypeSelected), nextLink -> this.getAvailableStacksOnPremNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ApplicationStackResourceInner> listAsync(ProviderOsTypeSelected osTypeSelected, Context context) {
        return new PagedFlux<ApplicationStackResourceInner>(() -> this.listSinglePageAsync(osTypeSelected, context), nextLink -> this.getAvailableStacksOnPremNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApplicationStackResourceInner> list() {
        ProviderOsTypeSelected osTypeSelected = null;
        return new PagedIterable<ApplicationStackResourceInner>(this.listAsync(osTypeSelected));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApplicationStackResourceInner> list(ProviderOsTypeSelected osTypeSelected, Context context) {
        return new PagedIterable<ApplicationStackResourceInner>(this.listAsync(osTypeSelected, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationStackResourceInner>> getAvailableStacksNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAvailableStacksNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ApplicationStackResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationStackCollection)res.getValue()).value(), ((ApplicationStackCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationStackResourceInner>> getAvailableStacksNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAvailableStacksNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, ApplicationStackResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationStackCollection)res.getValue()).value(), ((ApplicationStackCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FunctionAppStackInner>> getFunctionAppStacksNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getFunctionAppStacksNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, FunctionAppStackInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FunctionAppStackCollection)res.getValue()).value(), ((FunctionAppStackCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FunctionAppStackInner>> getFunctionAppStacksNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getFunctionAppStacksNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, FunctionAppStackInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FunctionAppStackCollection)res.getValue()).value(), ((FunctionAppStackCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FunctionAppStackInner>> getFunctionAppStacksForLocationNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getFunctionAppStacksForLocationNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, FunctionAppStackInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FunctionAppStackCollection)res.getValue()).value(), ((FunctionAppStackCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FunctionAppStackInner>> getFunctionAppStacksForLocationNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getFunctionAppStacksForLocationNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, FunctionAppStackInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FunctionAppStackCollection)res.getValue()).value(), ((FunctionAppStackCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WebAppStackInner>> getWebAppStacksForLocationNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getWebAppStacksForLocationNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, WebAppStackInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebAppStackCollection)res.getValue()).value(), ((WebAppStackCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WebAppStackInner>> getWebAppStacksForLocationNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getWebAppStacksForLocationNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, WebAppStackInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebAppStackCollection)res.getValue()).value(), ((WebAppStackCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CsmOperationDescriptionInner>> listOperationsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOperationsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, CsmOperationDescriptionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CsmOperationCollection)res.getValue()).value(), ((CsmOperationCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CsmOperationDescriptionInner>> listOperationsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listOperationsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, CsmOperationDescriptionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CsmOperationCollection)res.getValue()).value(), ((CsmOperationCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WebAppStackInner>> getWebAppStacksNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getWebAppStacksNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, WebAppStackInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebAppStackCollection)res.getValue()).value(), ((WebAppStackCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WebAppStackInner>> getWebAppStacksNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getWebAppStacksNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, WebAppStackInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebAppStackCollection)res.getValue()).value(), ((WebAppStackCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationStackResourceInner>> getAvailableStacksOnPremNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAvailableStacksOnPremNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ApplicationStackResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationStackCollection)res.getValue()).value(), ((ApplicationStackCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationStackResourceInner>> getAvailableStacksOnPremNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAvailableStacksOnPremNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, ApplicationStackResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationStackCollection)res.getValue()).value(), ((ApplicationStackCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="WebSiteManagementCli")
    public static interface ProvidersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Web/availableStacks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ApplicationStackCollection>> getAvailableStacks(@HostParam(value="$host") String var1, @QueryParam(value="osTypeSelected") ProviderOsTypeSelected var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Web/functionAppStacks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<FunctionAppStackCollection>> getFunctionAppStacks(@HostParam(value="$host") String var1, @QueryParam(value="stackOsType") ProviderStackOsType var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Web/locations/{location}/functionAppStacks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<FunctionAppStackCollection>> getFunctionAppStacksForLocation(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @QueryParam(value="stackOsType") ProviderStackOsType var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Web/locations/{location}/webAppStacks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<WebAppStackCollection>> getWebAppStacksForLocation(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @QueryParam(value="stackOsType") ProviderStackOsType var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Web/operations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<CsmOperationCollection>> listOperations(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Web/webAppStacks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<WebAppStackCollection>> getWebAppStacks(@HostParam(value="$host") String var1, @QueryParam(value="stackOsType") ProviderStackOsType var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Web/availableStacks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ApplicationStackCollection>> list(@HostParam(value="$host") String var1, @QueryParam(value="osTypeSelected") ProviderOsTypeSelected var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ApplicationStackCollection>> getAvailableStacksNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<FunctionAppStackCollection>> getFunctionAppStacksNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<FunctionAppStackCollection>> getFunctionAppStacksForLocationNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<WebAppStackCollection>> getWebAppStacksForLocationNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<CsmOperationCollection>> listOperationsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<WebAppStackCollection>> getWebAppStacksNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ApplicationStackCollection>> getAvailableStacksOnPremNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

