/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DetectorAbnormalTimePeriod;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Solution;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class AbnormalTimePeriod
implements JsonSerializable<AbnormalTimePeriod> {
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private List<DetectorAbnormalTimePeriod> events;
    private List<Solution> solutions;

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public AbnormalTimePeriod withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public AbnormalTimePeriod withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public List<DetectorAbnormalTimePeriod> events() {
        return this.events;
    }

    public AbnormalTimePeriod withEvents(List<DetectorAbnormalTimePeriod> events) {
        this.events = events;
        return this;
    }

    public List<Solution> solutions() {
        return this.solutions;
    }

    public AbnormalTimePeriod withSolutions(List<Solution> solutions) {
        this.solutions = solutions;
        return this;
    }

    public void validate() {
        if (this.events() != null) {
            this.events().forEach(e -> e.validate());
        }
        if (this.solutions() != null) {
            this.solutions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeArrayField("events", this.events, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("solutions", this.solutions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static AbnormalTimePeriod fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AbnormalTimePeriod deserializedAbnormalTimePeriod = new AbnormalTimePeriod();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedAbnormalTimePeriod.startTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedAbnormalTimePeriod.endTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("events".equals(fieldName)) {
                    List<DetectorAbnormalTimePeriod> events = reader.readArray(reader1 -> DetectorAbnormalTimePeriod.fromJson(reader1));
                    deserializedAbnormalTimePeriod.events = events;
                    continue;
                }
                if ("solutions".equals(fieldName)) {
                    List<Solution> solutions = reader.readArray(reader1 -> Solution.fromJson(reader1));
                    deserializedAbnormalTimePeriod.solutions = solutions;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAbnormalTimePeriod;
        });
    }
}

