/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DefaultAuthorizationPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.JwtClaimChecks;
import java.io.IOException;
import java.util.List;

public final class AzureActiveDirectoryValidation
implements JsonSerializable<AzureActiveDirectoryValidation> {
    private JwtClaimChecks jwtClaimChecks;
    private List<String> allowedAudiences;
    private DefaultAuthorizationPolicy defaultAuthorizationPolicy;

    public JwtClaimChecks jwtClaimChecks() {
        return this.jwtClaimChecks;
    }

    public AzureActiveDirectoryValidation withJwtClaimChecks(JwtClaimChecks jwtClaimChecks) {
        this.jwtClaimChecks = jwtClaimChecks;
        return this;
    }

    public List<String> allowedAudiences() {
        return this.allowedAudiences;
    }

    public AzureActiveDirectoryValidation withAllowedAudiences(List<String> allowedAudiences) {
        this.allowedAudiences = allowedAudiences;
        return this;
    }

    public DefaultAuthorizationPolicy defaultAuthorizationPolicy() {
        return this.defaultAuthorizationPolicy;
    }

    public AzureActiveDirectoryValidation withDefaultAuthorizationPolicy(DefaultAuthorizationPolicy defaultAuthorizationPolicy) {
        this.defaultAuthorizationPolicy = defaultAuthorizationPolicy;
        return this;
    }

    public void validate() {
        if (this.jwtClaimChecks() != null) {
            this.jwtClaimChecks().validate();
        }
        if (this.defaultAuthorizationPolicy() != null) {
            this.defaultAuthorizationPolicy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("jwtClaimChecks", this.jwtClaimChecks);
        jsonWriter.writeArrayField("allowedAudiences", this.allowedAudiences, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("defaultAuthorizationPolicy", this.defaultAuthorizationPolicy);
        return jsonWriter.writeEndObject();
    }

    public static AzureActiveDirectoryValidation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureActiveDirectoryValidation deserializedAzureActiveDirectoryValidation = new AzureActiveDirectoryValidation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("jwtClaimChecks".equals(fieldName)) {
                    deserializedAzureActiveDirectoryValidation.jwtClaimChecks = JwtClaimChecks.fromJson(reader);
                    continue;
                }
                if ("allowedAudiences".equals(fieldName)) {
                    List<String> allowedAudiences = reader.readArray(reader1 -> reader1.getString());
                    deserializedAzureActiveDirectoryValidation.allowedAudiences = allowedAudiences;
                    continue;
                }
                if ("defaultAuthorizationPolicy".equals(fieldName)) {
                    deserializedAzureActiveDirectoryValidation.defaultAuthorizationPolicy = DefaultAuthorizationPolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureActiveDirectoryValidation;
        });
    }
}

