/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ForwardProxy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.HttpSettingsRoutes;
import java.io.IOException;

public final class HttpSettings
implements JsonSerializable<HttpSettings> {
    private Boolean requireHttps;
    private HttpSettingsRoutes routes;
    private ForwardProxy forwardProxy;

    public Boolean requireHttps() {
        return this.requireHttps;
    }

    public HttpSettings withRequireHttps(Boolean requireHttps) {
        this.requireHttps = requireHttps;
        return this;
    }

    public HttpSettingsRoutes routes() {
        return this.routes;
    }

    public HttpSettings withRoutes(HttpSettingsRoutes routes) {
        this.routes = routes;
        return this;
    }

    public ForwardProxy forwardProxy() {
        return this.forwardProxy;
    }

    public HttpSettings withForwardProxy(ForwardProxy forwardProxy) {
        this.forwardProxy = forwardProxy;
        return this;
    }

    public void validate() {
        if (this.routes() != null) {
            this.routes().validate();
        }
        if (this.forwardProxy() != null) {
            this.forwardProxy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("requireHttps", this.requireHttps);
        jsonWriter.writeJsonField("routes", this.routes);
        jsonWriter.writeJsonField("forwardProxy", this.forwardProxy);
        return jsonWriter.writeEndObject();
    }

    public static HttpSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HttpSettings deserializedHttpSettings = new HttpSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("requireHttps".equals(fieldName)) {
                    deserializedHttpSettings.requireHttps = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("routes".equals(fieldName)) {
                    deserializedHttpSettings.routes = HttpSettingsRoutes.fromJson(reader);
                    continue;
                }
                if ("forwardProxy".equals(fieldName)) {
                    deserializedHttpSettings.forwardProxy = ForwardProxy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHttpSettings;
        });
    }
}

