/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.CookieExpiration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.LoginRoutes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Nonce;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.TokenStore;
import java.io.IOException;
import java.util.List;

public final class Login
implements JsonSerializable<Login> {
    private LoginRoutes routes;
    private TokenStore tokenStore;
    private Boolean preserveUrlFragmentsForLogins;
    private List<String> allowedExternalRedirectUrls;
    private CookieExpiration cookieExpiration;
    private Nonce nonce;

    public LoginRoutes routes() {
        return this.routes;
    }

    public Login withRoutes(LoginRoutes routes) {
        this.routes = routes;
        return this;
    }

    public TokenStore tokenStore() {
        return this.tokenStore;
    }

    public Login withTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
        return this;
    }

    public Boolean preserveUrlFragmentsForLogins() {
        return this.preserveUrlFragmentsForLogins;
    }

    public Login withPreserveUrlFragmentsForLogins(Boolean preserveUrlFragmentsForLogins) {
        this.preserveUrlFragmentsForLogins = preserveUrlFragmentsForLogins;
        return this;
    }

    public List<String> allowedExternalRedirectUrls() {
        return this.allowedExternalRedirectUrls;
    }

    public Login withAllowedExternalRedirectUrls(List<String> allowedExternalRedirectUrls) {
        this.allowedExternalRedirectUrls = allowedExternalRedirectUrls;
        return this;
    }

    public CookieExpiration cookieExpiration() {
        return this.cookieExpiration;
    }

    public Login withCookieExpiration(CookieExpiration cookieExpiration) {
        this.cookieExpiration = cookieExpiration;
        return this;
    }

    public Nonce nonce() {
        return this.nonce;
    }

    public Login withNonce(Nonce nonce) {
        this.nonce = nonce;
        return this;
    }

    public void validate() {
        if (this.routes() != null) {
            this.routes().validate();
        }
        if (this.tokenStore() != null) {
            this.tokenStore().validate();
        }
        if (this.cookieExpiration() != null) {
            this.cookieExpiration().validate();
        }
        if (this.nonce() != null) {
            this.nonce().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("routes", this.routes);
        jsonWriter.writeJsonField("tokenStore", this.tokenStore);
        jsonWriter.writeBooleanField("preserveUrlFragmentsForLogins", this.preserveUrlFragmentsForLogins);
        jsonWriter.writeArrayField("allowedExternalRedirectUrls", this.allowedExternalRedirectUrls, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("cookieExpiration", this.cookieExpiration);
        jsonWriter.writeJsonField("nonce", this.nonce);
        return jsonWriter.writeEndObject();
    }

    public static Login fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Login deserializedLogin = new Login();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("routes".equals(fieldName)) {
                    deserializedLogin.routes = LoginRoutes.fromJson(reader);
                    continue;
                }
                if ("tokenStore".equals(fieldName)) {
                    deserializedLogin.tokenStore = TokenStore.fromJson(reader);
                    continue;
                }
                if ("preserveUrlFragmentsForLogins".equals(fieldName)) {
                    deserializedLogin.preserveUrlFragmentsForLogins = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("allowedExternalRedirectUrls".equals(fieldName)) {
                    List<String> allowedExternalRedirectUrls = reader.readArray(reader1 -> reader1.getString());
                    deserializedLogin.allowedExternalRedirectUrls = allowedExternalRedirectUrls;
                    continue;
                }
                if ("cookieExpiration".equals(fieldName)) {
                    deserializedLogin.cookieExpiration = CookieExpiration.fromJson(reader);
                    continue;
                }
                if ("nonce".equals(fieldName)) {
                    deserializedLogin.nonce = Nonce.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogin;
        });
    }
}

