/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.Base64Url;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class MicrosoftGraphCertificateAuthority
implements JsonSerializable<MicrosoftGraphCertificateAuthority> {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private Base64Url certificate;
    private String certificateRevocationListUrl;
    private String deltaCertificateRevocationListUrl;
    private Boolean isRootAuthority;
    private String issuer;
    private String issuerSki;
    private Map<String, Object> additionalProperties;

    public byte[] certificate() {
        if (this.certificate == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return this.certificate.decodedBytes();
    }

    public MicrosoftGraphCertificateAuthority withCertificate(byte[] certificate) {
        this.certificate = certificate == null ? null : Base64Url.encode(CoreUtils.clone(certificate));
        return this;
    }

    public String certificateRevocationListUrl() {
        return this.certificateRevocationListUrl;
    }

    public MicrosoftGraphCertificateAuthority withCertificateRevocationListUrl(String certificateRevocationListUrl) {
        this.certificateRevocationListUrl = certificateRevocationListUrl;
        return this;
    }

    public String deltaCertificateRevocationListUrl() {
        return this.deltaCertificateRevocationListUrl;
    }

    public MicrosoftGraphCertificateAuthority withDeltaCertificateRevocationListUrl(String deltaCertificateRevocationListUrl) {
        this.deltaCertificateRevocationListUrl = deltaCertificateRevocationListUrl;
        return this;
    }

    public Boolean isRootAuthority() {
        return this.isRootAuthority;
    }

    public MicrosoftGraphCertificateAuthority withIsRootAuthority(Boolean isRootAuthority) {
        this.isRootAuthority = isRootAuthority;
        return this;
    }

    public String issuer() {
        return this.issuer;
    }

    public MicrosoftGraphCertificateAuthority withIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public String issuerSki() {
        return this.issuerSki;
    }

    public MicrosoftGraphCertificateAuthority withIssuerSki(String issuerSki) {
        this.issuerSki = issuerSki;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphCertificateAuthority withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("certificate", Objects.toString(this.certificate, null));
        jsonWriter.writeStringField("certificateRevocationListUrl", this.certificateRevocationListUrl);
        jsonWriter.writeStringField("deltaCertificateRevocationListUrl", this.deltaCertificateRevocationListUrl);
        jsonWriter.writeBooleanField("isRootAuthority", this.isRootAuthority);
        jsonWriter.writeStringField("issuer", this.issuer);
        jsonWriter.writeStringField("issuerSki", this.issuerSki);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphCertificateAuthority fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphCertificateAuthority deserializedMicrosoftGraphCertificateAuthority = new MicrosoftGraphCertificateAuthority();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("certificate".equals(fieldName)) {
                    deserializedMicrosoftGraphCertificateAuthority.certificate = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("certificateRevocationListUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphCertificateAuthority.certificateRevocationListUrl = reader.getString();
                    continue;
                }
                if ("deltaCertificateRevocationListUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphCertificateAuthority.deltaCertificateRevocationListUrl = reader.getString();
                    continue;
                }
                if ("isRootAuthority".equals(fieldName)) {
                    deserializedMicrosoftGraphCertificateAuthority.isRootAuthority = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("issuer".equals(fieldName)) {
                    deserializedMicrosoftGraphCertificateAuthority.issuer = reader.getString();
                    continue;
                }
                if ("issuerSki".equals(fieldName)) {
                    deserializedMicrosoftGraphCertificateAuthority.issuerSki = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphCertificateAuthority.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphCertificateAuthority;
        });
    }
}

