/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphNotebookLinks;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnenoteEntityHierarchyModel;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnenoteSection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnenoteUserRole;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSectionGroup;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphNotebook
extends MicrosoftGraphOnenoteEntityHierarchyModel {
    private Boolean isDefault;
    private Boolean isShared;
    private MicrosoftGraphNotebookLinks links;
    private String sectionGroupsUrl;
    private String sectionsUrl;
    private MicrosoftGraphOnenoteUserRole userRole;
    private List<MicrosoftGraphSectionGroup> sectionGroups;
    private List<MicrosoftGraphOnenoteSection> sections;
    private Map<String, Object> additionalProperties;

    public Boolean isDefault() {
        return this.isDefault;
    }

    public MicrosoftGraphNotebook withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public Boolean isShared() {
        return this.isShared;
    }

    public MicrosoftGraphNotebook withIsShared(Boolean isShared) {
        this.isShared = isShared;
        return this;
    }

    public MicrosoftGraphNotebookLinks links() {
        return this.links;
    }

    public MicrosoftGraphNotebook withLinks(MicrosoftGraphNotebookLinks links) {
        this.links = links;
        return this;
    }

    public String sectionGroupsUrl() {
        return this.sectionGroupsUrl;
    }

    public MicrosoftGraphNotebook withSectionGroupsUrl(String sectionGroupsUrl) {
        this.sectionGroupsUrl = sectionGroupsUrl;
        return this;
    }

    public String sectionsUrl() {
        return this.sectionsUrl;
    }

    public MicrosoftGraphNotebook withSectionsUrl(String sectionsUrl) {
        this.sectionsUrl = sectionsUrl;
        return this;
    }

    public MicrosoftGraphOnenoteUserRole userRole() {
        return this.userRole;
    }

    public MicrosoftGraphNotebook withUserRole(MicrosoftGraphOnenoteUserRole userRole) {
        this.userRole = userRole;
        return this;
    }

    public List<MicrosoftGraphSectionGroup> sectionGroups() {
        return this.sectionGroups;
    }

    public MicrosoftGraphNotebook withSectionGroups(List<MicrosoftGraphSectionGroup> sectionGroups) {
        this.sectionGroups = sectionGroups;
        return this;
    }

    public List<MicrosoftGraphOnenoteSection> sections() {
        return this.sections;
    }

    public MicrosoftGraphNotebook withSections(List<MicrosoftGraphOnenoteSection> sections) {
        this.sections = sections;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphNotebook withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphNotebook withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        super.withCreatedBy(createdBy);
        return this;
    }

    @Override
    public MicrosoftGraphNotebook withDisplayName(String displayName) {
        super.withDisplayName(displayName);
        return this;
    }

    @Override
    public MicrosoftGraphNotebook withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    @Override
    public MicrosoftGraphNotebook withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphNotebook withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphNotebook withSelf(String self) {
        super.withSelf(self);
        return this;
    }

    @Override
    public MicrosoftGraphNotebook withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.links() != null) {
            this.links().validate();
        }
        if (this.sectionGroups() != null) {
            this.sectionGroups().forEach(e -> e.validate());
        }
        if (this.sections() != null) {
            this.sections().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("self", this.self());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime()));
        jsonWriter.writeJsonField("createdBy", this.createdBy());
        jsonWriter.writeStringField("displayName", this.displayName());
        jsonWriter.writeJsonField("lastModifiedBy", this.lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime()));
        jsonWriter.writeBooleanField("isDefault", this.isDefault);
        jsonWriter.writeBooleanField("isShared", this.isShared);
        jsonWriter.writeJsonField("links", this.links);
        jsonWriter.writeStringField("sectionGroupsUrl", this.sectionGroupsUrl);
        jsonWriter.writeStringField("sectionsUrl", this.sectionsUrl);
        jsonWriter.writeStringField("userRole", this.userRole == null ? null : this.userRole.toString());
        jsonWriter.writeArrayField("sectionGroups", this.sectionGroups, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("sections", this.sections, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphNotebook fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphNotebook deserializedMicrosoftGraphNotebook = new MicrosoftGraphNotebook();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphNotebook.withId(reader.getString());
                    continue;
                }
                if ("self".equals(fieldName)) {
                    deserializedMicrosoftGraphNotebook.withSelf(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphNotebook.withCreatedDateTime(reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedMicrosoftGraphNotebook.withCreatedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphNotebook.withDisplayName(reader.getString());
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphNotebook.withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphNotebook.withLastModifiedDateTime(reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    continue;
                }
                if ("isDefault".equals(fieldName)) {
                    deserializedMicrosoftGraphNotebook.isDefault = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isShared".equals(fieldName)) {
                    deserializedMicrosoftGraphNotebook.isShared = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("links".equals(fieldName)) {
                    deserializedMicrosoftGraphNotebook.links = MicrosoftGraphNotebookLinks.fromJson(reader);
                    continue;
                }
                if ("sectionGroupsUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphNotebook.sectionGroupsUrl = reader.getString();
                    continue;
                }
                if ("sectionsUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphNotebook.sectionsUrl = reader.getString();
                    continue;
                }
                if ("userRole".equals(fieldName)) {
                    deserializedMicrosoftGraphNotebook.userRole = MicrosoftGraphOnenoteUserRole.fromString(reader.getString());
                    continue;
                }
                if ("sectionGroups".equals(fieldName)) {
                    List<MicrosoftGraphSectionGroup> sectionGroups = reader.readArray(reader1 -> MicrosoftGraphSectionGroup.fromJson(reader1));
                    deserializedMicrosoftGraphNotebook.sectionGroups = sectionGroups;
                    continue;
                }
                if ("sections".equals(fieldName)) {
                    List<MicrosoftGraphOnenoteSection> sections = reader.readArray(reader1 -> MicrosoftGraphOnenoteSection.fromJson(reader1));
                    deserializedMicrosoftGraphNotebook.sections = sections;
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphNotebook.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphNotebook;
        });
    }
}

