/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.AzureEnvironment;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPasswordCredentialInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.ActiveDirectoryApplicationImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.HasCredential;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.ServicePrincipalImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.PasswordCredential;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

class PasswordCredentialImpl<T extends HasCredential<T>>
extends IndexableRefreshableWrapperImpl<PasswordCredential, MicrosoftGraphPasswordCredentialInner>
implements PasswordCredential,
PasswordCredential.Definition<T> {
    private String name;
    private HasCredential<T> parent;
    OutputStream authFile;
    private String subscriptionId;
    private final List<Consumer<? super PasswordCredential>> consumers = new ArrayList<Consumer<? super PasswordCredential>>();
    private final ClientLogger logger = new ClientLogger(PasswordCredentialImpl.class);

    PasswordCredentialImpl(MicrosoftGraphPasswordCredentialInner passwordCredential) {
        super(passwordCredential);
        this.name = passwordCredential.displayName() != null ? passwordCredential.displayName() : passwordCredential.keyId().toString();
    }

    PasswordCredentialImpl(String name, HasCredential<T> parent) {
        super(new MicrosoftGraphPasswordCredentialInner().withDisplayName(name).withStartDateTime(OffsetDateTime.now()).withEndDateTime(OffsetDateTime.now().plusYears(1L)));
        this.name = name;
        this.parent = parent;
    }

    @Override
    public Mono<PasswordCredential> refreshAsync() {
        throw this.logger.logExceptionAsError(new UnsupportedOperationException("Cannot refresh credentials."));
    }

    @Override
    protected Mono<MicrosoftGraphPasswordCredentialInner> getInnerAsync() {
        throw this.logger.logExceptionAsError(new UnsupportedOperationException("Cannot refresh credentials."));
    }

    @Override
    public OffsetDateTime startDate() {
        return ((MicrosoftGraphPasswordCredentialInner)this.innerModel()).startDateTime();
    }

    @Override
    public OffsetDateTime endDate() {
        return ((MicrosoftGraphPasswordCredentialInner)this.innerModel()).endDateTime();
    }

    @Override
    public String value() {
        return ((MicrosoftGraphPasswordCredentialInner)this.innerModel()).secretText();
    }

    @Override
    public T attach() {
        return this.parent.withPasswordCredential(this);
    }

    @Override
    public PasswordCredentialImpl<T> withStartDate(OffsetDateTime startDate) {
        OffsetDateTime original = this.startDate();
        ((MicrosoftGraphPasswordCredentialInner)this.innerModel()).withStartDateTime(startDate);
        this.withDuration(Duration.between(original, this.endDate()));
        return this;
    }

    @Override
    public PasswordCredentialImpl<T> withDuration(Duration duration) {
        ((MicrosoftGraphPasswordCredentialInner)this.innerModel()).withEndDateTime(this.startDate().plus(duration));
        return this;
    }

    @Override
    public PasswordCredentialImpl<T> withAuthFileToExport(OutputStream outputStream2) {
        this.authFile = outputStream2;
        return this;
    }

    void exportAuthFile(ServicePrincipalImpl servicePrincipal) {
        this.exportAuthFile(servicePrincipal.manager().environment(), servicePrincipal.applicationId(), servicePrincipal.manager().tenantId());
    }

    void exportAuthFile(ActiveDirectoryApplicationImpl activeDirectoryApplication) {
        this.exportAuthFile(activeDirectoryApplication.manager().environment(), activeDirectoryApplication.applicationId(), activeDirectoryApplication.manager().tenantId());
    }

    void exportAuthFile(AzureEnvironment environment, String clientId, String tenantId) {
        if (this.authFile == null) {
            return;
        }
        StringBuilder builder = new StringBuilder("{\n");
        builder.append("  ").append(String.format("\"clientId\": \"%s\",", clientId)).append("\n");
        builder.append("  ").append(String.format("\"clientSecret\": \"%s\",", this.value())).append("\n");
        builder.append("  ").append(String.format("\"tenantId\": \"%s\",", tenantId)).append("\n");
        builder.append("  ").append(String.format("\"subscriptionId\": \"%s\",", this.subscriptionId)).append("\n");
        builder.append("  ").append(String.format("\"activeDirectoryEndpointUrl\": \"%s\",", environment.getActiveDirectoryEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"resourceManagerEndpointUrl\": \"%s\",", environment.getResourceManagerEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"activeDirectoryGraphResourceId\": \"%s\",", environment.getGraphEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"%s\": \"%s\",", AzureEnvironment.Endpoint.MICROSOFT_GRAPH.identifier(), environment.getMicrosoftGraphEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"managementEndpointUrl\": \"%s\"", environment.getManagementEndpoint())).append("\n");
        builder.append("}");
        try {
            this.authFile.write(builder.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
    }

    void consumeSecret() {
        this.consumers.forEach(consumer -> consumer.accept(this));
    }

    @Override
    public PasswordCredentialImpl<T> withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    @Override
    public String id() {
        return ((MicrosoftGraphPasswordCredentialInner)this.innerModel()).keyId().toString();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public PasswordCredentialImpl<T> withPasswordConsumer(Consumer<? super PasswordCredential> passwordConsumer) {
        this.consumers.add(passwordConsumer);
        return this;
    }
}

