/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ResourceReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.SecurityPolicyPropertiesParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.SecurityPolicyType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.SecurityPolicyWebApplicationFirewallAssociation;
import java.io.IOException;
import java.util.List;

public final class SecurityPolicyWebApplicationFirewallParameters
extends SecurityPolicyPropertiesParameters {
    private SecurityPolicyType type = SecurityPolicyType.WEB_APPLICATION_FIREWALL;
    private ResourceReference wafPolicy;
    private List<SecurityPolicyWebApplicationFirewallAssociation> associations;

    @Override
    public SecurityPolicyType type() {
        return this.type;
    }

    public ResourceReference wafPolicy() {
        return this.wafPolicy;
    }

    public SecurityPolicyWebApplicationFirewallParameters withWafPolicy(ResourceReference wafPolicy) {
        this.wafPolicy = wafPolicy;
        return this;
    }

    public List<SecurityPolicyWebApplicationFirewallAssociation> associations() {
        return this.associations;
    }

    public SecurityPolicyWebApplicationFirewallParameters withAssociations(List<SecurityPolicyWebApplicationFirewallAssociation> associations) {
        this.associations = associations;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.wafPolicy() != null) {
            this.wafPolicy().validate();
        }
        if (this.associations() != null) {
            this.associations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("wafPolicy", this.wafPolicy);
        jsonWriter.writeArrayField("associations", this.associations, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static SecurityPolicyWebApplicationFirewallParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityPolicyWebApplicationFirewallParameters deserializedSecurityPolicyWebApplicationFirewallParameters = new SecurityPolicyWebApplicationFirewallParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedSecurityPolicyWebApplicationFirewallParameters.type = SecurityPolicyType.fromString(reader.getString());
                    continue;
                }
                if ("wafPolicy".equals(fieldName)) {
                    deserializedSecurityPolicyWebApplicationFirewallParameters.wafPolicy = ResourceReference.fromJson(reader);
                    continue;
                }
                if ("associations".equals(fieldName)) {
                    List<SecurityPolicyWebApplicationFirewallAssociation> associations = reader.readArray(reader1 -> SecurityPolicyWebApplicationFirewallAssociation.fromJson(reader1));
                    deserializedSecurityPolicyWebApplicationFirewallParameters.associations = associations;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityPolicyWebApplicationFirewallParameters;
        });
    }
}

