/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.CertificateSource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.CustomDomainHttpsParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.KeyVaultCertificateSourceParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.MinimumTlsVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ProtocolType;
import java.io.IOException;

public final class UserManagedHttpsParameters
extends CustomDomainHttpsParameters {
    private CertificateSource certificateSource = CertificateSource.AZURE_KEY_VAULT;
    private KeyVaultCertificateSourceParameters certificateSourceParameters;
    private static final ClientLogger LOGGER = new ClientLogger(UserManagedHttpsParameters.class);

    @Override
    public CertificateSource certificateSource() {
        return this.certificateSource;
    }

    public KeyVaultCertificateSourceParameters certificateSourceParameters() {
        return this.certificateSourceParameters;
    }

    public UserManagedHttpsParameters withCertificateSourceParameters(KeyVaultCertificateSourceParameters certificateSourceParameters) {
        this.certificateSourceParameters = certificateSourceParameters;
        return this;
    }

    @Override
    public UserManagedHttpsParameters withProtocolType(ProtocolType protocolType) {
        super.withProtocolType(protocolType);
        return this;
    }

    @Override
    public UserManagedHttpsParameters withMinimumTlsVersion(MinimumTlsVersion minimumTlsVersion) {
        super.withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.certificateSourceParameters() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property certificateSourceParameters in model UserManagedHttpsParameters"));
        }
        this.certificateSourceParameters().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("protocolType", this.protocolType() == null ? null : this.protocolType().toString());
        jsonWriter.writeStringField("minimumTlsVersion", this.minimumTlsVersion() == null ? null : this.minimumTlsVersion().toString());
        jsonWriter.writeJsonField("certificateSourceParameters", this.certificateSourceParameters);
        jsonWriter.writeStringField("certificateSource", this.certificateSource == null ? null : this.certificateSource.toString());
        return jsonWriter.writeEndObject();
    }

    public static UserManagedHttpsParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserManagedHttpsParameters deserializedUserManagedHttpsParameters = new UserManagedHttpsParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("protocolType".equals(fieldName)) {
                    deserializedUserManagedHttpsParameters.withProtocolType(ProtocolType.fromString(reader.getString()));
                    continue;
                }
                if ("minimumTlsVersion".equals(fieldName)) {
                    deserializedUserManagedHttpsParameters.withMinimumTlsVersion(MinimumTlsVersion.fromString(reader.getString()));
                    continue;
                }
                if ("certificateSourceParameters".equals(fieldName)) {
                    deserializedUserManagedHttpsParameters.certificateSourceParameters = KeyVaultCertificateSourceParameters.fromJson(reader);
                    continue;
                }
                if ("certificateSource".equals(fieldName)) {
                    deserializedUserManagedHttpsParameters.certificateSource = CertificateSource.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserManagedHttpsParameters;
        });
    }
}

