/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.AccessControlRules;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.AccessControlRulesMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.EndpointAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GalleryResourceProfileVersionPropertiesBase;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ReplicationStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.TargetRegion;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class GalleryInVMAccessControlProfileVersionProperties
extends GalleryResourceProfileVersionPropertiesBase {
    private AccessControlRulesMode mode;
    private EndpointAccess defaultAccess;
    private AccessControlRules rules;
    private ReplicationStatus replicationStatus;
    private GalleryProvisioningState provisioningState;
    private OffsetDateTime publishedDate;
    private static final ClientLogger LOGGER = new ClientLogger(GalleryInVMAccessControlProfileVersionProperties.class);

    public AccessControlRulesMode mode() {
        return this.mode;
    }

    public GalleryInVMAccessControlProfileVersionProperties withMode(AccessControlRulesMode mode) {
        this.mode = mode;
        return this;
    }

    public EndpointAccess defaultAccess() {
        return this.defaultAccess;
    }

    public GalleryInVMAccessControlProfileVersionProperties withDefaultAccess(EndpointAccess defaultAccess) {
        this.defaultAccess = defaultAccess;
        return this;
    }

    public AccessControlRules rules() {
        return this.rules;
    }

    public GalleryInVMAccessControlProfileVersionProperties withRules(AccessControlRules rules) {
        this.rules = rules;
        return this;
    }

    @Override
    public ReplicationStatus replicationStatus() {
        return this.replicationStatus;
    }

    @Override
    public GalleryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    @Override
    public OffsetDateTime publishedDate() {
        return this.publishedDate;
    }

    @Override
    public GalleryInVMAccessControlProfileVersionProperties withTargetLocations(List<TargetRegion> targetLocations) {
        super.withTargetLocations(targetLocations);
        return this;
    }

    @Override
    public GalleryInVMAccessControlProfileVersionProperties withExcludeFromLatest(Boolean excludeFromLatest) {
        super.withExcludeFromLatest(excludeFromLatest);
        return this;
    }

    @Override
    public void validate() {
        if (this.mode() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property mode in model GalleryInVMAccessControlProfileVersionProperties"));
        }
        if (this.defaultAccess() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property defaultAccess in model GalleryInVMAccessControlProfileVersionProperties"));
        }
        if (this.rules() != null) {
            this.rules().validate();
        }
        if (this.targetLocations() != null) {
            this.targetLocations().forEach(e -> e.validate());
        }
        if (this.replicationStatus() != null) {
            this.replicationStatus().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targetLocations", this.targetLocations(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeBooleanField("excludeFromLatest", this.excludeFromLatest());
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeStringField("defaultAccess", this.defaultAccess == null ? null : this.defaultAccess.toString());
        jsonWriter.writeJsonField("rules", this.rules);
        return jsonWriter.writeEndObject();
    }

    public static GalleryInVMAccessControlProfileVersionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryInVMAccessControlProfileVersionProperties deserializedGalleryInVMAccessControlProfileVersionProperties = new GalleryInVMAccessControlProfileVersionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetLocations".equals(fieldName)) {
                    List<TargetRegion> targetLocations = reader.readArray(reader1 -> TargetRegion.fromJson(reader1));
                    deserializedGalleryInVMAccessControlProfileVersionProperties.withTargetLocations((List)targetLocations);
                    continue;
                }
                if ("excludeFromLatest".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionProperties.withExcludeFromLatest(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("publishedDate".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionProperties.publishedDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionProperties.provisioningState = GalleryProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("replicationStatus".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionProperties.replicationStatus = ReplicationStatus.fromJson(reader);
                    continue;
                }
                if ("mode".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionProperties.mode = AccessControlRulesMode.fromString(reader.getString());
                    continue;
                }
                if ("defaultAccess".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionProperties.defaultAccess = EndpointAccess.fromString(reader.getString());
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionProperties.rules = AccessControlRules.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryInVMAccessControlProfileVersionProperties;
        });
    }
}

