/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ResourceSkuCapabilities;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ResourceSkuCapacity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ResourceSkuCosts;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ResourceSkuLocationInfo;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ResourceSkuRestrictions;
import java.io.IOException;
import java.util.List;

public final class ResourceSkuInner
implements JsonSerializable<ResourceSkuInner> {
    private String resourceType;
    private String name;
    private String tier;
    private String size;
    private String family;
    private String kind;
    private ResourceSkuCapacity capacity;
    private List<String> locations;
    private List<ResourceSkuLocationInfo> locationInfo;
    private List<String> apiVersions;
    private List<ResourceSkuCosts> costs;
    private List<ResourceSkuCapabilities> capabilities;
    private List<ResourceSkuRestrictions> restrictions;

    public String resourceType() {
        return this.resourceType;
    }

    public String name() {
        return this.name;
    }

    public String tier() {
        return this.tier;
    }

    public String size() {
        return this.size;
    }

    public String family() {
        return this.family;
    }

    public String kind() {
        return this.kind;
    }

    public ResourceSkuCapacity capacity() {
        return this.capacity;
    }

    public List<String> locations() {
        return this.locations;
    }

    public List<ResourceSkuLocationInfo> locationInfo() {
        return this.locationInfo;
    }

    public List<String> apiVersions() {
        return this.apiVersions;
    }

    public List<ResourceSkuCosts> costs() {
        return this.costs;
    }

    public List<ResourceSkuCapabilities> capabilities() {
        return this.capabilities;
    }

    public List<ResourceSkuRestrictions> restrictions() {
        return this.restrictions;
    }

    public void validate() {
        if (this.capacity() != null) {
            this.capacity().validate();
        }
        if (this.locationInfo() != null) {
            this.locationInfo().forEach(e -> e.validate());
        }
        if (this.costs() != null) {
            this.costs().forEach(e -> e.validate());
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
        if (this.restrictions() != null) {
            this.restrictions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ResourceSkuInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceSkuInner deserializedResourceSkuInner = new ResourceSkuInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceType".equals(fieldName)) {
                    deserializedResourceSkuInner.resourceType = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedResourceSkuInner.name = reader.getString();
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedResourceSkuInner.tier = reader.getString();
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedResourceSkuInner.size = reader.getString();
                    continue;
                }
                if ("family".equals(fieldName)) {
                    deserializedResourceSkuInner.family = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedResourceSkuInner.kind = reader.getString();
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedResourceSkuInner.capacity = ResourceSkuCapacity.fromJson(reader);
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List<String> locations = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceSkuInner.locations = locations;
                    continue;
                }
                if ("locationInfo".equals(fieldName)) {
                    List<ResourceSkuLocationInfo> locationInfo = reader.readArray(reader1 -> ResourceSkuLocationInfo.fromJson(reader1));
                    deserializedResourceSkuInner.locationInfo = locationInfo;
                    continue;
                }
                if ("apiVersions".equals(fieldName)) {
                    List<String> apiVersions = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceSkuInner.apiVersions = apiVersions;
                    continue;
                }
                if ("costs".equals(fieldName)) {
                    List<ResourceSkuCosts> costs = reader.readArray(reader1 -> ResourceSkuCosts.fromJson(reader1));
                    deserializedResourceSkuInner.costs = costs;
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List<ResourceSkuCapabilities> capabilities = reader.readArray(reader1 -> ResourceSkuCapabilities.fromJson(reader1));
                    deserializedResourceSkuInner.capabilities = capabilities;
                    continue;
                }
                if ("restrictions".equals(fieldName)) {
                    List<ResourceSkuRestrictions> restrictions = reader.readArray(reader1 -> ResourceSkuRestrictions.fromJson(reader1));
                    deserializedResourceSkuInner.restrictions = restrictions;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceSkuInner;
        });
    }
}

