/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.ComputeManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.DisksClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.DiskInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.DiskImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.AccessLevel;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Disk;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Disks;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GrantAccessData;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.function.Function;

public class DisksImpl
extends TopLevelModifiableResourcesImpl<Disk, DiskImpl, DiskInner, DisksClient, ComputeManager>
implements Disks {
    private final ClientLogger logger = new ClientLogger(this.getClass());

    public DisksImpl(ComputeManager computeManager) {
        super(((ComputeManagementClient)computeManager.serviceClient()).getDisks(), computeManager);
    }

    @Override
    public String grantAccess(String resourceGroupName, String diskName, AccessLevel accessLevel, int accessDuration) {
        return this.grantAccessAsync(resourceGroupName, diskName, accessLevel, accessDuration).block();
    }

    @Override
    public Mono<String> grantAccessAsync(String resourceGroupName, String diskName, AccessLevel accessLevel, int accessDuration) {
        GrantAccessData grantAccessDataInner = new GrantAccessData();
        grantAccessDataInner.withAccess(accessLevel).withDurationInSeconds(accessDuration);
        return ((DisksClient)this.inner()).grantAccessAsync(resourceGroupName, diskName, grantAccessDataInner).map(accessUriInner -> accessUriInner.accessSas());
    }

    @Override
    public void revokeAccess(String resourceGroupName, String diskName) {
        ((DisksClient)this.inner()).revokeAccess(resourceGroupName, diskName);
    }

    @Override
    public Mono<Void> revokeAccessAsync(String resourceGroupName, String diskName) {
        return ((DisksClient)this.inner()).revokeAccessAsync(resourceGroupName, diskName);
    }

    @Override
    public Accepted<Void> beginDeleteById(String id) {
        return this.beginDeleteByResourceGroup(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(id));
    }

    @Override
    public Accepted<Void> beginDeleteByResourceGroup(String resourceGroupName, String name) {
        return AcceptedImpl.newAccepted(this.logger, ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getHttpPipeline(), ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDefaultPollInterval(), () -> ((DisksClient)this.inner()).deleteWithResponseAsync(resourceGroupName, name).block(), Function.identity(), Void.class, null, Context.NONE);
    }

    @Override
    protected DiskImpl wrapModel(String name) {
        return new DiskImpl(name, new DiskInner(), (ComputeManager)this.manager());
    }

    @Override
    protected DiskImpl wrapModel(DiskInner inner) {
        if (inner == null) {
            return null;
        }
        return new DiskImpl(inner.name(), inner, (ComputeManager)this.manager());
    }

    @Override
    public Disk.DefinitionStages.Blank define(String name) {
        return this.wrapModel(name);
    }
}

