/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.EncryptionExtensionIdentifier;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskEncryptionSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskVolumeType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.KeyVaultKeyReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.KeyVaultSecretReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineEncryptionConfiguration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.UUID;

abstract class EncryptionSettings {
    EncryptionSettings() {
    }

    abstract DiskEncryptionSettings storageProfileEncryptionSettings();

    abstract HashMap<String, Object> extensionPublicSettings();

    abstract HashMap<String, Object> extensionProtectedSettings();

    static <T extends VirtualMachineEncryptionConfiguration<T>> Enable<T> createEnable(VirtualMachineEncryptionConfiguration<T> config) {
        return new Enable<T>(config);
    }

    static Disable createDisable(DiskVolumeType volumeType) {
        return new Disable(volumeType);
    }

    static class Enable<T extends VirtualMachineEncryptionConfiguration<T>>
    extends EncryptionSettings {
        private final VirtualMachineEncryptionConfiguration<T> config;

        Enable(VirtualMachineEncryptionConfiguration<T> config) {
            this.config = config;
        }

        @Override
        DiskEncryptionSettings storageProfileEncryptionSettings() {
            KeyVaultKeyReference keyEncryptionKey = null;
            if (this.config.keyEncryptionKeyUrl() != null) {
                keyEncryptionKey = new KeyVaultKeyReference();
                keyEncryptionKey.withKeyUrl(this.config.keyEncryptionKeyUrl());
                if (this.config.keyEncryptionKeyVaultId() != null) {
                    keyEncryptionKey.withSourceVault(new SubResource().withId(this.config.keyEncryptionKeyVaultId()));
                }
            }
            DiskEncryptionSettings diskEncryptionSettings = new DiskEncryptionSettings();
            diskEncryptionSettings.withEnabled(true).withKeyEncryptionKey(keyEncryptionKey).withDiskEncryptionKey(new KeyVaultSecretReference()).diskEncryptionKey().withSourceVault(new SubResource().withId(this.config.keyVaultId()));
            return diskEncryptionSettings;
        }

        @Override
        HashMap<String, Object> extensionPublicSettings() {
            LinkedHashMap<String, Object> publicSettings = new LinkedHashMap<String, Object>();
            publicSettings.put("EncryptionOperation", "EnableEncryption");
            publicSettings.put("KeyEncryptionAlgorithm", this.config.volumeEncryptionKeyEncryptAlgorithm());
            publicSettings.put("KeyVaultURL", this.config.keyVaultUrl());
            publicSettings.put("VolumeType", this.config.volumeType().toString());
            publicSettings.put("SequenceVersion", UUID.randomUUID());
            if (this.config.keyEncryptionKeyUrl() != null) {
                publicSettings.put("KeyEncryptionKeyURL", this.config.keyEncryptionKeyUrl());
            }
            if (this.requestedForLegacyEncryptExtension()) {
                publicSettings.put("AADClientID", this.config.aadClientId());
            } else {
                publicSettings.put("KeyVaultResourceId", this.config.keyVaultId());
                if (this.config.keyEncryptionKeyUrl() != null && this.config.keyEncryptionKeyVaultId() != null) {
                    publicSettings.put("KekVaultResourceId", this.config.keyEncryptionKeyVaultId());
                }
            }
            return publicSettings;
        }

        @Override
        HashMap<String, Object> extensionProtectedSettings() {
            if (this.requestedForLegacyEncryptExtension()) {
                LinkedHashMap<String, Object> protectedSettings = new LinkedHashMap<String, Object>();
                protectedSettings.put("AADClientSecret", this.config.aadSecret());
                if (this.config.osType() == OperatingSystemTypes.LINUX && this.config.linuxPassPhrase() != null) {
                    protectedSettings.put("Passphrase", this.config.linuxPassPhrase());
                }
                return protectedSettings;
            }
            return new LinkedHashMap<String, Object>();
        }

        String encryptionExtensionVersion() {
            return EncryptionExtensionIdentifier.version(this.config.osType(), this.requestedForNoAADEncryptExtension());
        }

        boolean requestedForNoAADEncryptExtension() {
            return this.config.aadClientId() == null && this.config.aadSecret() == null;
        }

        boolean requestedForLegacyEncryptExtension() {
            return !this.requestedForNoAADEncryptExtension();
        }
    }

    static class Disable
    extends EncryptionSettings {
        private final DiskVolumeType volumeType;

        Disable(DiskVolumeType volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        DiskEncryptionSettings storageProfileEncryptionSettings() {
            DiskEncryptionSettings diskEncryptionSettings = new DiskEncryptionSettings();
            diskEncryptionSettings.withEnabled(false);
            return diskEncryptionSettings;
        }

        @Override
        HashMap<String, Object> extensionPublicSettings() {
            LinkedHashMap<String, Object> publicSettings = new LinkedHashMap<String, Object>();
            publicSettings.put("EncryptionOperation", "DisableEncryption");
            publicSettings.put("SequenceVersion", UUID.randomUUID());
            publicSettings.put("VolumeType", (Object)this.volumeType);
            return publicSettings;
        }

        @Override
        HashMap<String, Object> extensionProtectedSettings() {
            return new LinkedHashMap<String, Object>();
        }
    }
}

