/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.SerializerEncoding;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonProviders;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.ComputeManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.VirtualMachineExtensionsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.VirtualMachineExtensionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.VirtualMachineImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachine;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineExtension;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineExtensionImage;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineExtensionInstanceView;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

class VirtualMachineExtensionImpl
extends ExternalChildResourceImpl<VirtualMachineExtension, VirtualMachineExtensionInner, VirtualMachineImpl, VirtualMachine>
implements VirtualMachineExtension,
VirtualMachineExtension.Definition<VirtualMachine.DefinitionStages.WithCreate>,
VirtualMachineExtension.UpdateDefinition<VirtualMachine.Update>,
VirtualMachineExtension.Update {
    private final ClientLogger logger = new ClientLogger(VirtualMachineExtensionImpl.class);
    private final VirtualMachineExtensionsClient client;
    private Map<String, Object> publicSettings;
    private Map<String, Object> protectedSettings;

    VirtualMachineExtensionImpl(String name, VirtualMachineImpl parent, VirtualMachineExtensionInner inner, VirtualMachineExtensionsClient client) {
        super(name, parent, inner);
        this.client = client;
        this.initializeSettings();
    }

    protected static VirtualMachineExtensionImpl newVirtualMachineExtension(String name, VirtualMachineImpl parent, VirtualMachineExtensionsClient client) {
        VirtualMachineExtensionInner inner = new VirtualMachineExtensionInner();
        inner.withLocation(parent.regionName());
        VirtualMachineExtensionImpl extension = new VirtualMachineExtensionImpl(name, parent, inner, client);
        return extension;
    }

    @Override
    public String id() {
        return ((VirtualMachineExtensionInner)this.innerModel()).id();
    }

    @Override
    public String publisherName() {
        return ((VirtualMachineExtensionInner)this.innerModel()).publisher();
    }

    @Override
    public String typeName() {
        return ((VirtualMachineExtensionInner)this.innerModel()).typePropertiesType();
    }

    @Override
    public String versionName() {
        return ((VirtualMachineExtensionInner)this.innerModel()).typeHandlerVersion();
    }

    @Override
    public boolean autoUpgradeMinorVersionEnabled() {
        return ((VirtualMachineExtensionInner)this.innerModel()).autoUpgradeMinorVersion();
    }

    @Override
    public Map<String, Object> publicSettings() {
        return Collections.unmodifiableMap(this.publicSettings);
    }

    @Override
    public String publicSettingsAsJsonString() {
        try {
            return ((ComputeManagementClientImpl)((ComputeManager)((VirtualMachineImpl)this.parent()).manager()).serviceClient()).getSerializerAdapter().serialize(this.publicSettings, SerializerEncoding.JSON);
        }
        catch (IOException e) {
            this.logger.atWarning().log("Serialization failed for publicSettings.", e);
            return null;
        }
    }

    @Override
    public VirtualMachineExtensionInstanceView getInstanceView() {
        return this.getInstanceViewAsync().block();
    }

    @Override
    public Mono<VirtualMachineExtensionInstanceView> getInstanceViewAsync() {
        return this.client.getWithResponseAsync(((VirtualMachineImpl)this.parent()).resourceGroupName(), ((VirtualMachineImpl)this.parent()).name(), this.name(), "instanceView").flatMap(inner -> Mono.justOrEmpty(((VirtualMachineExtensionInner)inner.getValue()).instanceView()));
    }

    @Override
    public Map<String, String> tags() {
        Map<String, String> tags = ((VirtualMachineExtensionInner)this.innerModel()).tags();
        if (tags == null) {
            tags = new TreeMap<String, String>();
        }
        return Collections.unmodifiableMap(tags);
    }

    @Override
    public String provisioningState() {
        return ((VirtualMachineExtensionInner)this.innerModel()).provisioningState();
    }

    @Override
    public VirtualMachineExtensionImpl withMinorVersionAutoUpgrade() {
        ((VirtualMachineExtensionInner)this.innerModel()).withAutoUpgradeMinorVersion(true);
        return this;
    }

    @Override
    public VirtualMachineExtensionImpl withoutMinorVersionAutoUpgrade() {
        ((VirtualMachineExtensionInner)this.innerModel()).withAutoUpgradeMinorVersion(false);
        return this;
    }

    public VirtualMachineExtensionImpl withImage(VirtualMachineExtensionImage image) {
        ((VirtualMachineExtensionInner)this.innerModel()).withPublisher(image.publisherName()).withTypePropertiesType(image.typeName()).withTypeHandlerVersion(image.versionName());
        return this;
    }

    public VirtualMachineExtensionImpl withPublisher(String extensionImagePublisherName) {
        ((VirtualMachineExtensionInner)this.innerModel()).withPublisher(extensionImagePublisherName);
        return this;
    }

    @Override
    public VirtualMachineExtensionImpl withPublicSetting(String key, Object value) {
        this.publicSettings.put(key, value);
        return this;
    }

    @Override
    public VirtualMachineExtensionImpl withProtectedSetting(String key, Object value) {
        this.protectedSettings.put(key, value);
        return this;
    }

    @Override
    public VirtualMachineExtensionImpl withPublicSettings(HashMap<String, Object> settings) {
        this.publicSettings.clear();
        this.publicSettings.putAll(settings);
        return this;
    }

    @Override
    public VirtualMachineExtensionImpl withProtectedSettings(HashMap<String, Object> settings) {
        this.protectedSettings.clear();
        this.protectedSettings.putAll(settings);
        return this;
    }

    public VirtualMachineExtensionImpl withType(String extensionImageTypeName) {
        ((VirtualMachineExtensionInner)this.innerModel()).withTypePropertiesType(extensionImageTypeName);
        return this;
    }

    public VirtualMachineExtensionImpl withVersion(String extensionImageVersionName) {
        ((VirtualMachineExtensionInner)this.innerModel()).withTypeHandlerVersion(extensionImageVersionName);
        return this;
    }

    @Override
    public final VirtualMachineExtensionImpl withTags(Map<String, String> tags) {
        ((VirtualMachineExtensionInner)this.innerModel()).withTags(new HashMap<String, String>(tags));
        return this;
    }

    @Override
    public final VirtualMachineExtensionImpl withTag(String key, String value) {
        if (((VirtualMachineExtensionInner)this.innerModel()).tags() == null) {
            ((VirtualMachineExtensionInner)this.innerModel()).withTags((Map)new HashMap());
        }
        ((VirtualMachineExtensionInner)this.innerModel()).tags().put(key, value);
        return this;
    }

    @Override
    public final VirtualMachineExtensionImpl withoutTag(String key) {
        if (((VirtualMachineExtensionInner)this.innerModel()).tags() != null) {
            ((VirtualMachineExtensionInner)this.innerModel()).tags().remove(key);
        }
        return this;
    }

    @Override
    public VirtualMachineImpl attach() {
        this.nullifySettingsIfEmpty();
        return ((VirtualMachineImpl)this.parent()).withExtension(this);
    }

    @Override
    protected Mono<VirtualMachineExtensionInner> getInnerAsync() {
        String name = this.isReference() ? ResourceUtils.nameFromResourceId(((VirtualMachineExtensionInner)this.innerModel()).id()) : ((VirtualMachineExtensionInner)this.innerModel()).name();
        return this.client.getAsync(((VirtualMachineImpl)this.parent()).resourceGroupName(), ((VirtualMachineImpl)this.parent()).name(), name);
    }

    @Override
    public Mono<VirtualMachineExtension> createResourceAsync() {
        VirtualMachineExtensionImpl self = this;
        return this.client.createOrUpdateAsync(((VirtualMachineImpl)this.parent()).resourceGroupName(), ((VirtualMachineImpl)this.parent()).name(), this.name(), (VirtualMachineExtensionInner)this.innerModel()).map(inner -> {
            self.setInner(inner);
            self.initializeSettings();
            return self;
        });
    }

    @Override
    public Mono<VirtualMachineExtension> updateResourceAsync() {
        this.nullifySettingsIfEmpty();
        if (this.isReference()) {
            String extensionName = ResourceUtils.nameFromResourceId(((VirtualMachineExtensionInner)this.innerModel()).id());
            return this.client.getAsync(((VirtualMachineImpl)this.parent()).resourceGroupName(), ((VirtualMachineImpl)this.parent()).name(), extensionName).flatMap(resource -> {
                LinkedHashMap publicSettings;
                ((VirtualMachineExtensionInner)this.innerModel()).withPublisher(resource.publisher()).withTypePropertiesType(resource.typePropertiesType()).withTypeHandlerVersion(resource.typeHandlerVersion());
                if (((VirtualMachineExtensionInner)this.innerModel()).autoUpgradeMinorVersion() == null) {
                    ((VirtualMachineExtensionInner)this.innerModel()).withAutoUpgradeMinorVersion(resource.autoUpgradeMinorVersion());
                }
                if ((publicSettings = (LinkedHashMap)resource.settings()) != null && publicSettings.size() > 0) {
                    LinkedHashMap innerPublicSettings = (LinkedHashMap)((VirtualMachineExtensionInner)this.innerModel()).settings();
                    if (innerPublicSettings == null) {
                        ((VirtualMachineExtensionInner)this.innerModel()).withSettings(new LinkedHashMap());
                        innerPublicSettings = (LinkedHashMap)((VirtualMachineExtensionInner)this.innerModel()).settings();
                    }
                    for (Map.Entry entry : publicSettings.entrySet()) {
                        if (innerPublicSettings.containsKey(entry.getKey())) continue;
                        innerPublicSettings.put((String)entry.getKey(), entry.getValue());
                    }
                }
                return this.createResourceAsync();
            });
        }
        return this.createResourceAsync();
    }

    @Override
    public Mono<Void> deleteResourceAsync() {
        return this.client.deleteAsync(((VirtualMachineImpl)this.parent()).resourceGroupName(), ((VirtualMachineImpl)this.parent()).name(), this.name());
    }

    public boolean isReference() {
        return ((VirtualMachineExtensionInner)this.innerModel()).name() == null;
    }

    private void nullifySettingsIfEmpty() {
        if (this.publicSettings.size() == 0) {
            ((VirtualMachineExtensionInner)this.innerModel()).withSettings(null);
        }
        if (this.protectedSettings.size() == 0) {
            ((VirtualMachineExtensionInner)this.innerModel()).withProtectedSettings(null);
        }
    }

    private void initializeSettings() {
        if (((VirtualMachineExtensionInner)this.innerModel()).settings() == null) {
            this.publicSettings = new LinkedHashMap<String, Object>();
            ((VirtualMachineExtensionInner)this.innerModel()).withSettings(this.publicSettings);
        } else {
            this.publicSettings = this.loadSettings(((VirtualMachineExtensionInner)this.innerModel()).settings());
        }
        if (((VirtualMachineExtensionInner)this.innerModel()).protectedSettings() == null) {
            this.protectedSettings = new LinkedHashMap<String, Object>();
            ((VirtualMachineExtensionInner)this.innerModel()).withProtectedSettings(this.protectedSettings);
        } else {
            this.protectedSettings = this.loadSettings(((VirtualMachineExtensionInner)this.innerModel()).protectedSettings());
        }
    }

    private Map<String, Object> loadSettings(Object settings) {
        if (settings instanceof String) {
            Map<String, Object> map;
            block10: {
                JsonReader jsonReader = JsonProviders.createReader((String)settings);
                try {
                    map = jsonReader.readMap(JsonReader::readUntyped);
                    if (jsonReader == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (jsonReader != null) {
                            try {
                                jsonReader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.logger.atWarning().log("[VirtualMachineExtensionImpl] invalid String setting: {}", settings);
                        return new LinkedHashMap<String, Object>();
                    }
                }
                jsonReader.close();
            }
            return map;
        }
        if (settings instanceof Map) {
            return (Map)settings;
        }
        this.logger.atWarning().log("[VirtualMachineExtensionImpl] unrecognized setting type: {}, value: {}", settings.getClass(), settings);
        return new LinkedHashMap<String, Object>();
    }
}

