/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.AuthorizationManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.ComputeManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.VirtualMachinesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.VirtualMachineInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.RunCommandResultImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.VirtualMachineImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.VirtualMachineSizesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DataDisk;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ExpandTypeForListVMs;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.HardwareProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.NetworkInterfaceReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.NetworkProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.OSDisk;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.OSProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.RunCommandInput;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.RunCommandInputParameter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.RunCommandResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.StorageProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachine;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineCaptureParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineScaleSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineSizes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachines;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.StorageManager;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class VirtualMachinesImpl
extends TopLevelModifiableResourcesImpl<VirtualMachine, VirtualMachineImpl, VirtualMachineInner, VirtualMachinesClient, ComputeManager>
implements VirtualMachines {
    private final StorageManager storageManager;
    private final NetworkManager networkManager;
    private final AuthorizationManager authorizationManager;
    private final VirtualMachineSizesImpl vmSizes;
    private final ClientLogger logger = new ClientLogger(VirtualMachinesImpl.class);

    public VirtualMachinesImpl(ComputeManager computeManager, StorageManager storageManager, NetworkManager networkManager, AuthorizationManager authorizationManager) {
        super(((ComputeManagementClient)computeManager.serviceClient()).getVirtualMachines(), computeManager);
        this.storageManager = storageManager;
        this.networkManager = networkManager;
        this.authorizationManager = authorizationManager;
        this.vmSizes = new VirtualMachineSizesImpl(((ComputeManagementClient)computeManager.serviceClient()).getVirtualMachineSizes());
    }

    @Override
    public VirtualMachine.DefinitionStages.Blank define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public void deallocate(String groupName, String name) {
        ((VirtualMachinesClient)this.inner()).deallocate(groupName, name);
    }

    @Override
    public Mono<Void> deallocateAsync(String groupName, String name) {
        return ((VirtualMachinesClient)this.inner()).deallocateAsync(groupName, name);
    }

    @Override
    public void deallocate(String groupName, String name, boolean hibernate) {
        ((VirtualMachinesClient)this.inner()).deallocate(groupName, name, hibernate, Context.NONE);
    }

    @Override
    public Mono<Void> deallocateAsync(String groupName, String name, boolean hibernate) {
        return ((VirtualMachinesClient)this.inner()).deallocateAsync(groupName, name, hibernate);
    }

    @Override
    public void generalize(String groupName, String name) {
        ((VirtualMachinesClient)this.inner()).generalize(groupName, name);
    }

    @Override
    public Mono<Void> generalizeAsync(String groupName, String name) {
        return ((VirtualMachinesClient)this.inner()).generalizeAsync(groupName, name);
    }

    @Override
    public void powerOff(String groupName, String name) {
        this.powerOffAsync(groupName, name).block();
    }

    @Override
    public Mono<Void> powerOffAsync(String groupName, String name) {
        return ((VirtualMachinesClient)this.inner()).powerOffAsync(groupName, name, null);
    }

    @Override
    public void restart(String groupName, String name) {
        ((VirtualMachinesClient)this.inner()).restart(groupName, name);
    }

    @Override
    public Mono<Void> restartAsync(String groupName, String name) {
        return ((VirtualMachinesClient)this.inner()).restartAsync(groupName, name);
    }

    @Override
    public void start(String groupName, String name) {
        ((VirtualMachinesClient)this.inner()).start(groupName, name);
    }

    @Override
    public Mono<Void> startAsync(String groupName, String name) {
        return ((VirtualMachinesClient)this.inner()).startAsync(groupName, name);
    }

    @Override
    public void redeploy(String groupName, String name) {
        ((VirtualMachinesClient)this.inner()).redeploy(groupName, name);
    }

    @Override
    public Mono<Void> redeployAsync(String groupName, String name) {
        return ((VirtualMachinesClient)this.inner()).redeployAsync(groupName, name);
    }

    @Override
    public String capture(String groupName, String name, String containerName, String vhdPrefix, boolean overwriteVhd) {
        return this.captureAsync(groupName, name, containerName, vhdPrefix, overwriteVhd).block();
    }

    @Override
    public Mono<String> captureAsync(String groupName, String name, String containerName, String vhdPrefix, boolean overwriteVhd) {
        VirtualMachineCaptureParameters parameters = new VirtualMachineCaptureParameters();
        parameters.withDestinationContainerName(containerName);
        parameters.withOverwriteVhds(overwriteVhd);
        parameters.withVhdPrefix(vhdPrefix);
        return ((VirtualMachinesClient)this.inner()).captureAsync(groupName, name, parameters).map(captureResult -> VirtualMachineImpl.serializeCaptureResult(captureResult, this.logger));
    }

    @Override
    public void migrateToManaged(String groupName, String name) {
        ((VirtualMachinesClient)this.inner()).convertToManagedDisks(groupName, name);
    }

    @Override
    public Mono<Void> migrateToManagedAsync(String groupName, String name) {
        return ((VirtualMachinesClient)this.inner()).convertToManagedDisksAsync(groupName, name);
    }

    @Override
    public RunCommandResult runPowerShellScript(String groupName, String name, List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        return this.runPowerShellScriptAsync(groupName, name, scriptLines, scriptParameters).block();
    }

    @Override
    public Mono<RunCommandResult> runPowerShellScriptAsync(String groupName, String name, List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        RunCommandInput inputCommand = new RunCommandInput();
        inputCommand.withCommandId("RunPowerShellScript");
        inputCommand.withScript(scriptLines);
        inputCommand.withParameters(scriptParameters);
        return this.runCommandAsync(groupName, name, inputCommand);
    }

    @Override
    public RunCommandResult runShellScript(String groupName, String name, List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        return this.runShellScriptAsync(groupName, name, scriptLines, scriptParameters).block();
    }

    @Override
    public Mono<RunCommandResult> runShellScriptAsync(String groupName, String name, List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        RunCommandInput inputCommand = new RunCommandInput();
        inputCommand.withCommandId("RunShellScript");
        inputCommand.withScript(scriptLines);
        inputCommand.withParameters(scriptParameters);
        return this.runCommandAsync(groupName, name, inputCommand);
    }

    @Override
    public RunCommandResult runCommand(String groupName, String name, RunCommandInput inputCommand) {
        return this.runCommandAsync(groupName, name, inputCommand).block();
    }

    @Override
    public Mono<RunCommandResult> runCommandAsync(String groupName, String name, RunCommandInput inputCommand) {
        return ((VirtualMachinesClient)this.inner()).runCommandAsync(groupName, name, inputCommand).map(RunCommandResultImpl::new);
    }

    @Override
    public Accepted<Void> beginDeleteById(String id) {
        return this.beginDeleteByResourceGroup(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(id));
    }

    @Override
    public Accepted<Void> beginDeleteByResourceGroup(String resourceGroupName, String name) {
        return AcceptedImpl.newAccepted(this.logger, ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getHttpPipeline(), ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDefaultPollInterval(), () -> ((VirtualMachinesClient)this.inner()).deleteWithResponseAsync(resourceGroupName, name, null).block(), Function.identity(), Void.class, null, Context.NONE);
    }

    @Override
    public void deleteById(String id, boolean forceDeletion) {
        this.deleteByIdAsync(id, forceDeletion).block();
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id, boolean forceDeletion) {
        return this.deleteByResourceGroupAsync(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(id), forceDeletion);
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String name, boolean forceDeletion) {
        this.deleteByResourceGroupAsync(resourceGroupName, name, forceDeletion).block();
    }

    @Override
    public Mono<Void> deleteByResourceGroupAsync(String resourceGroupName, String name, boolean forceDeletion) {
        return ((VirtualMachinesClient)this.inner()).deleteAsync(resourceGroupName, name, forceDeletion);
    }

    @Override
    public Accepted<Void> beginDeleteById(String id, boolean forceDeletion) {
        return this.beginDeleteByResourceGroup(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(id), forceDeletion);
    }

    @Override
    public Accepted<Void> beginDeleteByResourceGroup(String resourceGroupName, String name, boolean forceDeletion) {
        return AcceptedImpl.newAccepted(this.logger, ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getHttpPipeline(), ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDefaultPollInterval(), () -> ((VirtualMachinesClient)this.inner()).deleteWithResponseAsync(resourceGroupName, name, forceDeletion).block(), Function.identity(), Void.class, null, Context.NONE);
    }

    @Override
    public PagedIterable<VirtualMachine> listByVirtualMachineScaleSetId(String vmssId) {
        return new PagedIterable<VirtualMachine>(this.listByVirtualMachineScaleSetIdAsync(vmssId));
    }

    @Override
    public PagedFlux<VirtualMachine> listByVirtualMachineScaleSetIdAsync(String vmssId) {
        Method listNextSinglePageAsync;
        Method listSinglePageAsync;
        if (CoreUtils.isNullOrEmpty(vmssId)) {
            return new PagedFlux<VirtualMachine>(() -> Mono.error(new IllegalArgumentException("Parameter 'vmssId' is required and cannot be null.")));
        }
        try {
            listSinglePageAsync = ((VirtualMachinesClient)this.inner()).getClass().getDeclaredMethod("listByResourceGroupSinglePageAsync", String.class, String.class, ExpandTypeForListVMs.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        try {
            listNextSinglePageAsync = ((VirtualMachinesClient)this.inner()).getClass().getDeclaredMethod("listNextSinglePageAsync", String.class, Context.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        AccessController.doPrivileged(() -> {
            listSinglePageAsync.setAccessible(true);
            listNextSinglePageAsync.setAccessible(true);
            return null;
        });
        return this.wrapPageAsync(new PagedFlux(() -> {
            try {
                return (Mono)listSinglePageAsync.invoke(this.inner(), ResourceUtils.groupFromResourceId(vmssId), String.format("'virtualMachineScaleSet/id' eq '%s'", vmssId), null);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }, nextLink -> {
            try {
                return (Mono)listNextSinglePageAsync.invoke(this.inner(), ResourceUtils.encodeResourceId(nextLink), Context.NONE);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    @Override
    public PagedIterable<VirtualMachine> listByVirtualMachineScaleSet(VirtualMachineScaleSet vmss) {
        return new PagedIterable<VirtualMachine>(this.listByVirtualMachineScaleSetAsync(vmss));
    }

    @Override
    public PagedFlux<VirtualMachine> listByVirtualMachineScaleSetAsync(VirtualMachineScaleSet vmss) {
        if (vmss == null) {
            return new PagedFlux<VirtualMachine>(() -> Mono.error(new IllegalArgumentException("Parameter 'vmss' is required and cannot be null.")));
        }
        return this.listByVirtualMachineScaleSetIdAsync(vmss.id());
    }

    @Override
    public VirtualMachineSizes sizes() {
        return this.vmSizes;
    }

    @Override
    protected VirtualMachineImpl wrapModel(String name) {
        VirtualMachineInner inner = new VirtualMachineInner();
        inner.withStorageProfile(new StorageProfile().withOsDisk(new OSDisk()).withDataDisks(new ArrayList<DataDisk>()));
        inner.withOsProfile(new OSProfile());
        inner.withHardwareProfile(new HardwareProfile());
        inner.withNetworkProfile(new NetworkProfile().withNetworkInterfaces(new ArrayList<NetworkInterfaceReference>()));
        return new VirtualMachineImpl(name, inner, (ComputeManager)this.manager(), this.storageManager, this.networkManager, this.authorizationManager);
    }

    @Override
    protected VirtualMachineImpl wrapModel(VirtualMachineInner virtualMachineInner) {
        if (virtualMachineInner == null) {
            return null;
        }
        return new VirtualMachineImpl(virtualMachineInner.name(), virtualMachineInner, (ComputeManager)this.manager(), this.storageManager, this.networkManager, this.authorizationManager);
    }
}

