/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CreationData;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CreationSourceType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskCreateOption;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ImageDiskReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;

public class CreationSource {
    private final CreationData creationData;

    public CreationSource(CreationData creationData) {
        this.creationData = creationData;
    }

    public CreationSourceType type() {
        DiskCreateOption createOption = this.creationData.createOption();
        if (createOption == DiskCreateOption.FROM_IMAGE) {
            ImageDiskReference imageReference = this.creationData.imageReference();
            if (imageReference.lun() == null) {
                return CreationSourceType.FROM_OS_DISK_IMAGE;
            }
            return CreationSourceType.FROM_DATA_DISK_IMAGE;
        }
        if (createOption == DiskCreateOption.IMPORT) {
            return CreationSourceType.IMPORTED_FROM_VHD;
        }
        if (createOption == DiskCreateOption.COPY || createOption == DiskCreateOption.COPY_START) {
            String sourceResourceId = this.creationData.sourceResourceId();
            if (sourceResourceId == null && this.creationData.sourceUri() != null) {
                sourceResourceId = this.creationData.sourceUri();
            }
            if (sourceResourceId != null) {
                String resourceType = ResourceUtils.resourceTypeFromResourceId(sourceResourceId);
                if ("disks".equalsIgnoreCase(resourceType)) {
                    return CreationSourceType.COPIED_FROM_DISK;
                }
                if ("snapshots".equalsIgnoreCase(resourceType)) {
                    return CreationSourceType.COPIED_FROM_SNAPSHOT;
                }
            }
        }
        if (createOption == DiskCreateOption.EMPTY) {
            return CreationSourceType.EMPTY;
        }
        return CreationSourceType.UNKNOWN;
    }

    public String sourceId() {
        if (this.type() == CreationSourceType.FROM_OS_DISK_IMAGE || this.type() == CreationSourceType.FROM_DATA_DISK_IMAGE) {
            return this.creationData.imageReference().id();
        }
        if (this.type() == CreationSourceType.IMPORTED_FROM_VHD) {
            return this.creationData.sourceUri();
        }
        if (this.type() == CreationSourceType.COPIED_FROM_DISK) {
            String sourceResourceId = this.creationData.sourceResourceId();
            if (sourceResourceId == null) {
                sourceResourceId = this.creationData.sourceUri();
            }
            return sourceResourceId;
        }
        if (this.type() == CreationSourceType.COPIED_FROM_SNAPSHOT) {
            String sourceResourceId = this.creationData.sourceResourceId();
            if (sourceResourceId == null) {
                sourceResourceId = this.creationData.sourceUri();
            }
            return sourceResourceId;
        }
        return null;
    }

    public int sourceDataDiskImageLun() {
        if (this.type() == CreationSourceType.FROM_DATA_DISK_IMAGE) {
            return this.creationData.imageReference().lun();
        }
        return -1;
    }
}

