/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.DedicatedHostGroupProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DedicatedHostGroupInstanceView;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DedicatedHostGroupPropertiesAdditionalCapabilities;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.UpdateResource;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DedicatedHostGroupUpdate
extends UpdateResource {
    private DedicatedHostGroupProperties innerProperties;
    private List<String> zones;

    private DedicatedHostGroupProperties innerProperties() {
        return this.innerProperties;
    }

    public List<String> zones() {
        return this.zones;
    }

    public DedicatedHostGroupUpdate withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    @Override
    public DedicatedHostGroupUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Integer platformFaultDomainCount() {
        return this.innerProperties() == null ? null : Integer.valueOf(this.innerProperties().platformFaultDomainCount());
    }

    public DedicatedHostGroupUpdate withPlatformFaultDomainCount(Integer platformFaultDomainCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DedicatedHostGroupProperties();
        }
        this.innerProperties().withPlatformFaultDomainCount(platformFaultDomainCount);
        return this;
    }

    public List<SubResourceReadOnly> hosts() {
        return this.innerProperties() == null ? null : this.innerProperties().hosts();
    }

    public DedicatedHostGroupInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    public Boolean supportAutomaticPlacement() {
        return this.innerProperties() == null ? null : this.innerProperties().supportAutomaticPlacement();
    }

    public DedicatedHostGroupUpdate withSupportAutomaticPlacement(Boolean supportAutomaticPlacement) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DedicatedHostGroupProperties();
        }
        this.innerProperties().withSupportAutomaticPlacement(supportAutomaticPlacement);
        return this;
    }

    public DedicatedHostGroupPropertiesAdditionalCapabilities additionalCapabilities() {
        return this.innerProperties() == null ? null : this.innerProperties().additionalCapabilities();
    }

    public DedicatedHostGroupUpdate withAdditionalCapabilities(DedicatedHostGroupPropertiesAdditionalCapabilities additionalCapabilities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DedicatedHostGroupProperties();
        }
        this.innerProperties().withAdditionalCapabilities(additionalCapabilities);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static DedicatedHostGroupUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DedicatedHostGroupUpdate deserializedDedicatedHostGroupUpdate = new DedicatedHostGroupUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDedicatedHostGroupUpdate.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDedicatedHostGroupUpdate.innerProperties = DedicatedHostGroupProperties.fromJson(reader);
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List<String> zones = reader.readArray(reader1 -> reader1.getString());
                    deserializedDedicatedHostGroupUpdate.zones = zones;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDedicatedHostGroupUpdate;
        });
    }
}

