/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.DedicatedHostProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DedicatedHostInstanceView;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DedicatedHostLicenseTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Sku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.UpdateResource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class DedicatedHostUpdate
extends UpdateResource {
    private DedicatedHostProperties innerProperties;
    private Sku sku;

    private DedicatedHostProperties innerProperties() {
        return this.innerProperties;
    }

    public Sku sku() {
        return this.sku;
    }

    public DedicatedHostUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    @Override
    public DedicatedHostUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Integer platformFaultDomain() {
        return this.innerProperties() == null ? null : this.innerProperties().platformFaultDomain();
    }

    public DedicatedHostUpdate withPlatformFaultDomain(Integer platformFaultDomain) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DedicatedHostProperties();
        }
        this.innerProperties().withPlatformFaultDomain(platformFaultDomain);
        return this;
    }

    public Boolean autoReplaceOnFailure() {
        return this.innerProperties() == null ? null : this.innerProperties().autoReplaceOnFailure();
    }

    public DedicatedHostUpdate withAutoReplaceOnFailure(Boolean autoReplaceOnFailure) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DedicatedHostProperties();
        }
        this.innerProperties().withAutoReplaceOnFailure(autoReplaceOnFailure);
        return this;
    }

    public String hostId() {
        return this.innerProperties() == null ? null : this.innerProperties().hostId();
    }

    public List<SubResourceReadOnly> virtualMachines() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachines();
    }

    public DedicatedHostLicenseTypes licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    public DedicatedHostUpdate withLicenseType(DedicatedHostLicenseTypes licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DedicatedHostProperties();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    public OffsetDateTime provisioningTime() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningTime();
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public DedicatedHostInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    public OffsetDateTime timeCreated() {
        return this.innerProperties() == null ? null : this.innerProperties().timeCreated();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeJsonField("sku", this.sku);
        return jsonWriter.writeEndObject();
    }

    public static DedicatedHostUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DedicatedHostUpdate deserializedDedicatedHostUpdate = new DedicatedHostUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDedicatedHostUpdate.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDedicatedHostUpdate.innerProperties = DedicatedHostProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedDedicatedHostUpdate.sku = Sku.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDedicatedHostUpdate;
        });
    }
}

