/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ValidationStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ExecutedValidation
implements JsonSerializable<ExecutedValidation> {
    private String type;
    private ValidationStatus status;
    private String version;
    private OffsetDateTime executionTime;

    public String type() {
        return this.type;
    }

    public ExecutedValidation withType(String type) {
        this.type = type;
        return this;
    }

    public ValidationStatus status() {
        return this.status;
    }

    public ExecutedValidation withStatus(ValidationStatus status) {
        this.status = status;
        return this;
    }

    public String version() {
        return this.version;
    }

    public ExecutedValidation withVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime executionTime() {
        return this.executionTime;
    }

    public ExecutedValidation withExecutionTime(OffsetDateTime executionTime) {
        this.executionTime = executionTime;
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeStringField("executionTime", this.executionTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.executionTime));
        return jsonWriter.writeEndObject();
    }

    public static ExecutedValidation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExecutedValidation deserializedExecutedValidation = new ExecutedValidation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedExecutedValidation.type = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedExecutedValidation.status = ValidationStatus.fromString(reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedExecutedValidation.version = reader.getString();
                    continue;
                }
                if ("executionTime".equals(fieldName)) {
                    deserializedExecutedValidation.executionTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExecutedValidation;
        });
    }
}

