/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.AccessLevel;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.FileFormat;
import java.io.IOException;

public final class GrantAccessData
implements JsonSerializable<GrantAccessData> {
    private AccessLevel access;
    private int durationInSeconds;
    private Boolean getSecureVMGuestStateSas;
    private FileFormat fileFormat;
    private static final ClientLogger LOGGER = new ClientLogger(GrantAccessData.class);

    public AccessLevel access() {
        return this.access;
    }

    public GrantAccessData withAccess(AccessLevel access) {
        this.access = access;
        return this;
    }

    public int durationInSeconds() {
        return this.durationInSeconds;
    }

    public GrantAccessData withDurationInSeconds(int durationInSeconds) {
        this.durationInSeconds = durationInSeconds;
        return this;
    }

    public Boolean getSecureVMGuestStateSas() {
        return this.getSecureVMGuestStateSas;
    }

    public GrantAccessData withGetSecureVMGuestStateSas(Boolean getSecureVMGuestStateSas) {
        this.getSecureVMGuestStateSas = getSecureVMGuestStateSas;
        return this;
    }

    public FileFormat fileFormat() {
        return this.fileFormat;
    }

    public GrantAccessData withFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    public void validate() {
        if (this.access() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property access in model GrantAccessData"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("access", this.access == null ? null : this.access.toString());
        jsonWriter.writeIntField("durationInSeconds", this.durationInSeconds);
        jsonWriter.writeBooleanField("getSecureVMGuestStateSAS", this.getSecureVMGuestStateSas);
        jsonWriter.writeStringField("fileFormat", this.fileFormat == null ? null : this.fileFormat.toString());
        return jsonWriter.writeEndObject();
    }

    public static GrantAccessData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GrantAccessData deserializedGrantAccessData = new GrantAccessData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("access".equals(fieldName)) {
                    deserializedGrantAccessData.access = AccessLevel.fromString(reader.getString());
                    continue;
                }
                if ("durationInSeconds".equals(fieldName)) {
                    deserializedGrantAccessData.durationInSeconds = reader.getInt();
                    continue;
                }
                if ("getSecureVMGuestStateSAS".equals(fieldName)) {
                    deserializedGrantAccessData.getSecureVMGuestStateSas = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("fileFormat".equals(fieldName)) {
                    deserializedGrantAccessData.fileFormat = FileFormat.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGrantAccessData;
        });
    }
}

