/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.NetworkApiVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.NetworkInterfaceReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineNetworkInterfaceConfiguration;
import java.io.IOException;
import java.util.List;

public final class NetworkProfile
implements JsonSerializable<NetworkProfile> {
    private List<NetworkInterfaceReference> networkInterfaces;
    private NetworkApiVersion networkApiVersion;
    private List<VirtualMachineNetworkInterfaceConfiguration> networkInterfaceConfigurations;

    public List<NetworkInterfaceReference> networkInterfaces() {
        return this.networkInterfaces;
    }

    public NetworkProfile withNetworkInterfaces(List<NetworkInterfaceReference> networkInterfaces) {
        this.networkInterfaces = networkInterfaces;
        return this;
    }

    public NetworkApiVersion networkApiVersion() {
        return this.networkApiVersion;
    }

    public NetworkProfile withNetworkApiVersion(NetworkApiVersion networkApiVersion) {
        this.networkApiVersion = networkApiVersion;
        return this;
    }

    public List<VirtualMachineNetworkInterfaceConfiguration> networkInterfaceConfigurations() {
        return this.networkInterfaceConfigurations;
    }

    public NetworkProfile withNetworkInterfaceConfigurations(List<VirtualMachineNetworkInterfaceConfiguration> networkInterfaceConfigurations) {
        this.networkInterfaceConfigurations = networkInterfaceConfigurations;
        return this;
    }

    public void validate() {
        if (this.networkInterfaces() != null) {
            this.networkInterfaces().forEach(e -> e.validate());
        }
        if (this.networkInterfaceConfigurations() != null) {
            this.networkInterfaceConfigurations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("networkInterfaces", this.networkInterfaces, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("networkApiVersion", this.networkApiVersion == null ? null : this.networkApiVersion.toString());
        jsonWriter.writeArrayField("networkInterfaceConfigurations", this.networkInterfaceConfigurations, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkProfile deserializedNetworkProfile = new NetworkProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("networkInterfaces".equals(fieldName)) {
                    List<NetworkInterfaceReference> networkInterfaces = reader.readArray(reader1 -> NetworkInterfaceReference.fromJson(reader1));
                    deserializedNetworkProfile.networkInterfaces = networkInterfaces;
                    continue;
                }
                if ("networkApiVersion".equals(fieldName)) {
                    deserializedNetworkProfile.networkApiVersion = NetworkApiVersion.fromString(reader.getString());
                    continue;
                }
                if ("networkInterfaceConfigurations".equals(fieldName)) {
                    List<VirtualMachineNetworkInterfaceConfiguration> networkInterfaceConfigurations = reader.readArray(reader1 -> VirtualMachineNetworkInterfaceConfiguration.fromJson(reader1));
                    deserializedNetworkProfile.networkInterfaceConfigurations = networkInterfaceConfigurations;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkProfile;
        });
    }
}

