/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CachingTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DeleteOptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskEncryptionSetParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.StorageAccountTypes;

public final class VirtualMachineDiskOptions {
    private StorageAccountTypes storageAccountType;
    private CachingTypes cachingTypes;
    private DeleteOptions deleteOptions;
    private Boolean writeAcceleratorEnabled;
    private DiskEncryptionSetParameters diskEncryptionSetOptions;

    public StorageAccountTypes storageAccountType() {
        return this.storageAccountType;
    }

    public CachingTypes cachingTypes() {
        return this.cachingTypes;
    }

    public DeleteOptions deleteOptions() {
        return this.deleteOptions;
    }

    public Boolean writeAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    public boolean isDiskEncryptionSetConfigured() {
        return this.diskEncryptionSetOptions != null;
    }

    public String diskEncryptionSetId() {
        if (this.diskEncryptionSetOptions == null) {
            return null;
        }
        return this.diskEncryptionSetOptions.id();
    }

    public VirtualMachineDiskOptions withStorageAccountTypes(StorageAccountTypes storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

    public VirtualMachineDiskOptions withCachingTypes(CachingTypes cachingTypes) {
        this.cachingTypes = cachingTypes;
        return this;
    }

    public VirtualMachineDiskOptions withDeleteOptions(DeleteOptions deleteOptions) {
        this.deleteOptions = deleteOptions;
        return this;
    }

    public VirtualMachineDiskOptions withWriteAcceleratorEnabled(boolean writeAcceleratorEnabled) {
        this.writeAcceleratorEnabled = writeAcceleratorEnabled;
        return this;
    }

    public VirtualMachineDiskOptions withDiskEncryptionSet(String diskEncryptionSetId) {
        if (CoreUtils.isNullOrEmpty(diskEncryptionSetId)) {
            if (this.diskEncryptionSetOptions == null) {
                this.diskEncryptionSetOptions = new DiskEncryptionSetParameters();
            }
            this.diskEncryptionSetOptions.withId(null);
        } else {
            if (this.diskEncryptionSetOptions == null) {
                this.diskEncryptionSetOptions = new DiskEncryptionSetParameters();
            }
            this.diskEncryptionSetOptions.withId(diskEncryptionSetId);
        }
        return this;
    }
}

