/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.fluent.models.InitContainerPropertiesDefinition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.EnvironmentVariable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.InitContainerPropertiesDefinitionInstanceView;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.SecurityContextDefinition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.VolumeMount;
import java.io.IOException;
import java.util.List;

public final class InitContainerDefinition
implements JsonSerializable<InitContainerDefinition> {
    private String name;
    private InitContainerPropertiesDefinition innerProperties = new InitContainerPropertiesDefinition();
    private static final ClientLogger LOGGER = new ClientLogger(InitContainerDefinition.class);

    public String name() {
        return this.name;
    }

    public InitContainerDefinition withName(String name) {
        this.name = name;
        return this;
    }

    private InitContainerPropertiesDefinition innerProperties() {
        return this.innerProperties;
    }

    public String image() {
        return this.innerProperties() == null ? null : this.innerProperties().image();
    }

    public InitContainerDefinition withImage(String image) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InitContainerPropertiesDefinition();
        }
        this.innerProperties().withImage(image);
        return this;
    }

    public List<String> command() {
        return this.innerProperties() == null ? null : this.innerProperties().command();
    }

    public InitContainerDefinition withCommand(List<String> command) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InitContainerPropertiesDefinition();
        }
        this.innerProperties().withCommand(command);
        return this;
    }

    public List<EnvironmentVariable> environmentVariables() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentVariables();
    }

    public InitContainerDefinition withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InitContainerPropertiesDefinition();
        }
        this.innerProperties().withEnvironmentVariables(environmentVariables);
        return this;
    }

    public InitContainerPropertiesDefinitionInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    public List<VolumeMount> volumeMounts() {
        return this.innerProperties() == null ? null : this.innerProperties().volumeMounts();
    }

    public InitContainerDefinition withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InitContainerPropertiesDefinition();
        }
        this.innerProperties().withVolumeMounts(volumeMounts);
        return this;
    }

    public SecurityContextDefinition securityContext() {
        return this.innerProperties() == null ? null : this.innerProperties().securityContext();
    }

    public InitContainerDefinition withSecurityContext(SecurityContextDefinition securityContext) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InitContainerPropertiesDefinition();
        }
        this.innerProperties().withSecurityContext(securityContext);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model InitContainerDefinition"));
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property innerProperties in model InitContainerDefinition"));
        }
        this.innerProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static InitContainerDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            InitContainerDefinition deserializedInitContainerDefinition = new InitContainerDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedInitContainerDefinition.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedInitContainerDefinition.innerProperties = InitContainerPropertiesDefinition.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInitContainerDefinition;
        });
    }
}

