/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.ContainerRegistryManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.ContainerRegistryManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.TasksClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models.TaskInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation.RegistryTaskImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.RegistryTask;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.RegistryTasks;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public class RegistryTasksImpl
implements RegistryTasks {
    private final ContainerRegistryManager registryManager;

    public RegistryTasksImpl(ContainerRegistryManager registryManager) {
        this.registryManager = registryManager;
    }

    @Override
    public RegistryTask.DefinitionStages.Blank define(String name) {
        return new RegistryTaskImpl(this.registryManager, name);
    }

    @Override
    public PagedFlux<RegistryTask> listByRegistryAsync(String resourceGroupName, String registryName) {
        return PagedConverter.mapPage(((ContainerRegistryManagementClient)this.registryManager.serviceClient()).getTasks().listAsync(resourceGroupName, registryName), inner -> this.wrapModel((TaskInner)inner));
    }

    @Override
    public PagedIterable<RegistryTask> listByRegistry(String resourceGroupName, String registryName) {
        return new PagedIterable<RegistryTask>(this.listByRegistryAsync(resourceGroupName, registryName));
    }

    @Override
    public Mono<RegistryTask> getByRegistryAsync(String resourceGroupName, String registryName, String taskName, boolean includeSecrets) {
        if (includeSecrets) {
            return ((ContainerRegistryManagementClient)this.registryManager.serviceClient()).getTasks().getDetailsAsync(resourceGroupName, registryName, taskName).map(taskInner -> new RegistryTaskImpl(this.registryManager, (TaskInner)taskInner));
        }
        return ((ContainerRegistryManagementClient)this.registryManager.serviceClient()).getTasks().getAsync(resourceGroupName, registryName, taskName).map(taskInner -> new RegistryTaskImpl(this.registryManager, (TaskInner)taskInner));
    }

    @Override
    public RegistryTask getByRegistry(String resourceGroupName, String registryName, String taskName, boolean includeSecrets) {
        return this.getByRegistryAsync(resourceGroupName, registryName, taskName, includeSecrets).block();
    }

    @Override
    public Mono<Void> deleteByRegistryAsync(String resourceGroupName, String registryName, String taskName) {
        return ((ContainerRegistryManagementClient)this.registryManager.serviceClient()).getTasks().deleteAsync(resourceGroupName, registryName, taskName);
    }

    @Override
    public void deleteByRegistry(String resourceGroupName, String registryName, String taskName) {
        this.deleteByRegistryAsync(resourceGroupName, registryName, taskName).block();
    }

    private RegistryTaskImpl wrapModel(TaskInner innerModel) {
        return new RegistryTaskImpl(this.registryManager, innerModel);
    }

    public TasksClient inner() {
        return ((ContainerRegistryManagementClient)this.registryManager.serviceClient()).getTasks();
    }
}

