/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.CredentialHealth;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.CredentialName;
import java.io.IOException;

public final class AuthCredential
implements JsonSerializable<AuthCredential> {
    private CredentialName name;
    private String usernameSecretIdentifier;
    private String passwordSecretIdentifier;
    private CredentialHealth credentialHealth;

    public CredentialName name() {
        return this.name;
    }

    public AuthCredential withName(CredentialName name) {
        this.name = name;
        return this;
    }

    public String usernameSecretIdentifier() {
        return this.usernameSecretIdentifier;
    }

    public AuthCredential withUsernameSecretIdentifier(String usernameSecretIdentifier) {
        this.usernameSecretIdentifier = usernameSecretIdentifier;
        return this;
    }

    public String passwordSecretIdentifier() {
        return this.passwordSecretIdentifier;
    }

    public AuthCredential withPasswordSecretIdentifier(String passwordSecretIdentifier) {
        this.passwordSecretIdentifier = passwordSecretIdentifier;
        return this;
    }

    public CredentialHealth credentialHealth() {
        return this.credentialHealth;
    }

    public void validate() {
        if (this.credentialHealth() != null) {
            this.credentialHealth().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeStringField("usernameSecretIdentifier", this.usernameSecretIdentifier);
        jsonWriter.writeStringField("passwordSecretIdentifier", this.passwordSecretIdentifier);
        return jsonWriter.writeEndObject();
    }

    public static AuthCredential fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AuthCredential deserializedAuthCredential = new AuthCredential();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAuthCredential.name = CredentialName.fromString(reader.getString());
                    continue;
                }
                if ("usernameSecretIdentifier".equals(fieldName)) {
                    deserializedAuthCredential.usernameSecretIdentifier = reader.getString();
                    continue;
                }
                if ("passwordSecretIdentifier".equals(fieldName)) {
                    deserializedAuthCredential.passwordSecretIdentifier = reader.getString();
                    continue;
                }
                if ("credentialHealth".equals(fieldName)) {
                    deserializedAuthCredential.credentialHealth = CredentialHealth.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAuthCredential;
        });
    }
}

