/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class KeyVaultProperties
implements JsonSerializable<KeyVaultProperties> {
    private String keyIdentifier;
    private String versionedKeyIdentifier;
    private String identity;
    private Boolean keyRotationEnabled;
    private OffsetDateTime lastKeyRotationTimestamp;

    public String keyIdentifier() {
        return this.keyIdentifier;
    }

    public KeyVaultProperties withKeyIdentifier(String keyIdentifier) {
        this.keyIdentifier = keyIdentifier;
        return this;
    }

    public String versionedKeyIdentifier() {
        return this.versionedKeyIdentifier;
    }

    public String identity() {
        return this.identity;
    }

    public KeyVaultProperties withIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public Boolean keyRotationEnabled() {
        return this.keyRotationEnabled;
    }

    public OffsetDateTime lastKeyRotationTimestamp() {
        return this.lastKeyRotationTimestamp;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyIdentifier", this.keyIdentifier);
        jsonWriter.writeStringField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    public static KeyVaultProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyVaultProperties deserializedKeyVaultProperties = new KeyVaultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyIdentifier".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyIdentifier = reader.getString();
                    continue;
                }
                if ("versionedKeyIdentifier".equals(fieldName)) {
                    deserializedKeyVaultProperties.versionedKeyIdentifier = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedKeyVaultProperties.identity = reader.getString();
                    continue;
                }
                if ("keyRotationEnabled".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyRotationEnabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("lastKeyRotationTimestamp".equals(fieldName)) {
                    deserializedKeyVaultProperties.lastKeyRotationTimestamp = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyVaultProperties;
        });
    }
}

