/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.Architecture;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.OS;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.Variant;
import java.io.IOException;

public final class PlatformProperties
implements JsonSerializable<PlatformProperties> {
    private OS os;
    private Architecture architecture;
    private Variant variant;
    private static final ClientLogger LOGGER = new ClientLogger(PlatformProperties.class);

    public OS os() {
        return this.os;
    }

    public PlatformProperties withOs(OS os) {
        this.os = os;
        return this;
    }

    public Architecture architecture() {
        return this.architecture;
    }

    public PlatformProperties withArchitecture(Architecture architecture) {
        this.architecture = architecture;
        return this;
    }

    public Variant variant() {
        return this.variant;
    }

    public PlatformProperties withVariant(Variant variant) {
        this.variant = variant;
        return this;
    }

    public void validate() {
        if (this.os() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property os in model PlatformProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("os", this.os == null ? null : this.os.toString());
        jsonWriter.writeStringField("architecture", this.architecture == null ? null : this.architecture.toString());
        jsonWriter.writeStringField("variant", this.variant == null ? null : this.variant.toString());
        return jsonWriter.writeEndObject();
    }

    public static PlatformProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PlatformProperties deserializedPlatformProperties = new PlatformProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("os".equals(fieldName)) {
                    deserializedPlatformProperties.os = OS.fromString(reader.getString());
                    continue;
                }
                if ("architecture".equals(fieldName)) {
                    deserializedPlatformProperties.architecture = Architecture.fromString(reader.getString());
                    continue;
                }
                if ("variant".equals(fieldName)) {
                    deserializedPlatformProperties.variant = Variant.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPlatformProperties;
        });
    }
}

